/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.chaid.serialize;

import com.ibm.bi.predict.algorithms.tree.DecisionTree;
import com.ibm.bi.predict.algorithms.tree.NodeContent;
import com.ibm.bi.predict.algorithms.tree.summary.SummaryStats;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.store.DataArray;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.chaid.serialize.SerializedNodeContent;
import com.ibm.bi.predict.fastpattern.chaid.summary.SerializedCategoricalSummaryStats;
import com.ibm.bi.predict.fastpattern.chaid.summary.SerializedContinuousSummaryStats;
import com.ibm.bi.predict.fastpattern.exceptions.FastPatternException;
import com.ibm.bi.predict.graph.TreeNode;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TreeDeserializer {
    private static final String JSON_EXCEPTION = "Failed to parse JSON with exception: %s";

    private TreeDeserializer() {
    }

    public static DecisionTree deserialize(JSONObject serialized) {
        try {
            JSONArray results = serialized.getJSONArray("results");
            JSONObject json = results.getJSONObject(0);
            JSONObject fields = json.getJSONObject("fields");
            DataColumn target = TreeDeserializer.getDataColumn(fields.getJSONObject("target"), 0);
            JSONArray arr1 = fields.getJSONArray("inputs");
            List<DataColumn> predictors = TreeDeserializer.getPredictors(arr1);
            JSONObject details = json.getJSONObject("details");
            JSONObject structure = details.getJSONObject("structure");
            TreeNode<NodeContent> root = TreeDeserializer.makeNode(structure, predictors, target, null);
            return new DecisionTree(root, target);
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format(JSON_EXCEPTION, new Object[]{e}));
        }
    }

    private static List<DataColumn> getPredictors(JSONArray json) {
        ArrayList<DataColumn> predictors = new ArrayList<DataColumn>();
        int index = 1;
        for (Object obj : json) {
            JSONObject jsonObj = (JSONObject)obj;
            DataColumn column = TreeDeserializer.getDataColumn(jsonObj, index);
            predictors.add(column);
            ++index;
        }
        return predictors;
    }

    private static DataColumn getDataColumn(JSONObject json, int index) {
        try {
            FieldType type;
            String id = json.getString("id");
            String label = json.getString("label");
            ArrayList<Category> categories = new ArrayList<Category>();
            if (json.containsKey((Object)"categories")) {
                type = FieldType.CATEGORICAL;
                JSONArray cats = json.getJSONArray("categories");
                for (Object categoryObj : cats) {
                    categories.add(Category.forString((String)((String)categoryObj)));
                }
            } else {
                type = FieldType.NUMERICAL;
            }
            DataColumn.ColumnMeta meta = new DataColumn.ColumnMeta(id, label, type, AggregationType.NONE);
            return new DataColumn(meta, categories, DataArray.of(null), Collections.emptySet(), index);
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format(JSON_EXCEPTION, new Object[]{e}));
        }
    }

    private static TreeNode<NodeContent> makeNode(JSONObject json, List<DataColumn> predictors, DataColumn target, TreeNode<NodeContent> parent) {
        try {
            SummaryStats stats = TreeDeserializer.makeSummaryStats(target.getType(), json);
            NodeContent content = TreeDeserializer.makeNodeContent(json, predictors, parent, stats);
            TreeNode currentNode = new TreeNode("", (Object)content, parent);
            TreeNode<NodeContent>[] children = TreeDeserializer.makeChildren((TreeNode<NodeContent>)currentNode, json, predictors, target);
            currentNode.setChildren(children);
            return currentNode;
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format(JSON_EXCEPTION, new Object[]{e}));
        }
    }

    private static NodeContent makeNodeContent(JSONObject json, List<DataColumn> predictors, TreeNode<NodeContent> parent, SummaryStats stats) throws JSONException {
        if (parent == null) {
            return new SerializedNodeContent(stats);
        }
        String splitFieldName = json.getString("splitField");
        JSONObject splitCondition = (JSONObject)json.get("splitCondition");
        DataColumn splitField = TreeDeserializer.getFieldFromId(splitFieldName, predictors);
        Tuple<List<Category>, Set<Double>> split = TreeDeserializer.getSplitCondition(splitCondition, splitField);
        List categories = (List)split._1;
        Set splitValues = (Set)split._2;
        return new SerializedNodeContent(stats, splitField, categories, splitValues);
    }

    private static TreeNode<NodeContent>[] makeChildren(TreeNode<NodeContent> parent, JSONObject json, List<DataColumn> predictors, DataColumn target) {
        try {
            if (json.containsKey((Object)"children")) {
                JSONArray childrenArray = json.getJSONArray("children");
                TreeNode[] children = new TreeNode[childrenArray.length()];
                for (int i = 0; i < childrenArray.length(); ++i) {
                    TreeNode<NodeContent> child;
                    JSONObject childObject = childrenArray.getJSONObject(i);
                    children[i] = child = TreeDeserializer.makeNode(childObject, predictors, target, parent);
                }
                return children;
            }
            return null;
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format(JSON_EXCEPTION, new Object[]{e}));
        }
    }

    private static SummaryStats makeSummaryStats(FieldType type, JSONObject json) throws JSONException {
        int count = json.getInt("count");
        double value = json.getDouble("value");
        if (type.equals((Object)FieldType.CATEGORICAL)) {
            JSONArray frequencies = json.getJSONArray("frequencies");
            int[] frequencyArr = new int[frequencies.length()];
            for (int i = 0; i < frequencyArr.length; ++i) {
                frequencyArr[i] = (Integer)frequencies.get(i);
            }
            return new SerializedCategoricalSummaryStats(frequencyArr, value, count);
        }
        double std = json.getDouble("stdDev");
        return new SerializedContinuousSummaryStats(value, std, count);
    }

    private static DataColumn getFieldFromId(String fieldId, List<DataColumn> predictors) {
        for (DataColumn col : predictors) {
            if (!col.getId().equals(fieldId)) continue;
            return col;
        }
        return null;
    }

    private static Tuple<List<Category>, Set<Double>> getSplitCondition(JSONObject splitCondition, DataColumn field) {
        try {
            if (field == null) {
                throw new FastPatternException("Cannot get split condition for null field");
            }
            if (field.getType().equals((Object)FieldType.CATEGORICAL)) {
                return TreeDeserializer.getCategoricalSplitCondition(splitCondition, field);
            }
            if (field.getType().equals((Object)FieldType.NUMERICAL)) {
                return TreeDeserializer.getNumericSplitCondition(splitCondition);
            }
            return null;
        }
        catch (JSONException e) {
            throw new FastPatternException(String.format(JSON_EXCEPTION, new Object[]{e}));
        }
    }

    private static Tuple<List<Category>, Set<Double>> getCategoricalSplitCondition(JSONObject splitCondition, DataColumn field) throws JSONException {
        ArrayList categories = new ArrayList();
        HashSet<Double> values = new HashSet<Double>();
        JSONArray categoryArray = splitCondition.getJSONArray("categories");
        for (Object obj : categoryArray) {
            double v = Double.parseDouble(obj.toString());
            categories.add(field.getCategories().get((int)v));
            values.add(v);
        }
        return new Tuple(categories, values);
    }

    private static Tuple<List<Category>, Set<Double>> getNumericSplitCondition(JSONObject splitCondition) throws JSONException {
        ArrayList<Category> categories = new ArrayList<Category>();
        HashSet<Double> values = new HashSet<Double>();
        double minInclusive = -1.7976931348623157E308;
        double maxExclusive = Double.MAX_VALUE;
        if (splitCondition.containsKey((Object)"minInclusive")) {
            minInclusive = splitCondition.getDouble("minInclusive");
        }
        if (splitCondition.containsKey((Object)"maxExclusive")) {
            maxExclusive = splitCondition.getDouble("maxExclusive");
        }
        values.add(minInclusive);
        values.add(maxExclusive);
        Category range = Category.forBin((double)minInclusive, (double)maxExclusive);
        categories.add(range);
        return new Tuple(categories, values);
    }
}

