/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.chaid.serialize;

import com.ibm.bi.predict.algorithms.tree.DecisionTree;
import com.ibm.bi.predict.algorithms.tree.NodeContent;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.exceptions.TreeException;
import com.ibm.bi.predict.graph.TreeNode;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang.ArrayUtils;

public class TreeJsonBuilder {
    private static final Logger LOG = PredictLoggerFactory.getLogger(TreeJsonBuilder.class);
    private static final int MAX_SHORT_LABEL_CATEGORIES = 2;
    private static final int NUMBER_OF_SIGNIFICANT_DIGITS = 6;
    private final DecisionTree tree;
    private final Locale locale;

    public TreeJsonBuilder(DecisionTree tree, Locale locale) {
        this.tree = tree;
        this.locale = locale;
    }

    public JSONObject build() {
        return this.build(null);
    }

    public JSONObject build(Map<Integer, Integer> targetCategoryIndexNewToOldMap) {
        Map<Integer, Integer> targetCategoryNewToOldIndexMap = this.getTargetCategoryIndexNewToOldMap(targetCategoryIndexNewToOldMap);
        OptOrderedJSONObject json = new OptOrderedJSONObject();
        try {
            json.put("structure", (Map)this.nodeValue((TreeNode<NodeContent>)this.tree.rootNode(), targetCategoryIndexNewToOldMap, targetCategoryNewToOldIndexMap));
        }
        catch (Exception e) {
            String message = String.format("Error building json for tree. Message: %s", e.getMessage());
            LOG.error(message, (Throwable)e);
            throw new TreeException(message);
        }
        return json;
    }

    private JSONObject nodeValue(TreeNode<NodeContent> node, Map<Integer, Integer> targetCategoryIndexNewToOldMap, Map<Integer, Integer> targetCategoryIndexOldToNewMap) {
        try {
            OptOrderedJSONObject json = new OptOrderedJSONObject();
            json.put("depth", node.depth()).put("count", ((NodeContent)node.content()).rowCount()).put("value", TreeJsonBuilder.roundValue(node, targetCategoryIndexOldToNewMap)).putOpt("stdDev", (Object)this.stdDevValue(node)).putOpt("frequencies", (Object)this.frequenciesValue(node, targetCategoryIndexNewToOldMap)).putOpt("splitField", (Object)TreeJsonBuilder.splitFieldValue(node)).putOpt("splitCondition", (Object)TreeJsonBuilder.splitConditionValue(node)).putOpt("label", (Object)this.labelValue(node)).putOpt("shortLabel", (Object)this.shortLabelValue(node)).putOpt("shortSplitLabel", (Object)this.shortSplitLabelValue(node)).putOpt("children", (Object)this.childrenValue(node, targetCategoryIndexNewToOldMap, targetCategoryIndexOldToNewMap));
            return json;
        }
        catch (Exception e) {
            String message = String.format("Error building json for tree. Message: %s", e.getMessage());
            LOG.error(message, (Throwable)e);
            throw new TreeException(message);
        }
    }

    private static double roundValue(TreeNode<NodeContent> node, Map<Integer, Integer> targetCategoryIndexOldToNewMap) {
        if (targetCategoryIndexOldToNewMap == null) {
            return NumericUtils.round((double)((NodeContent)node.content()).expectedValue(), (int)6);
        }
        return targetCategoryIndexOldToNewMap.get((int)NumericUtils.round((double)((NodeContent)node.content()).expectedValue(), (int)6)).intValue();
    }

    private Double stdDevValue(TreeNode<NodeContent> node) {
        if (this.tree.target().getType() == FieldType.NUMERICAL && !Double.isNaN(((NodeContent)node.content()).stats().std())) {
            return NumericUtils.round((double)((NodeContent)node.content()).stats().std(), (int)6);
        }
        return null;
    }

    private JSONArray frequenciesValue(TreeNode<NodeContent> node, Map<Integer, Integer> targetCategoryIndexNewToOldMap) {
        if (this.tree.target().getType() == FieldType.NUMERICAL) {
            return null;
        }
        JSONArray frequencies = new JSONArray();
        int[] freqValues = ((NodeContent)node.content()).stats().categoryFrequencies();
        if (targetCategoryIndexNewToOldMap != null && targetCategoryIndexNewToOldMap.size() == freqValues.length) {
            int[] newFreqValues = new int[freqValues.length];
            for (int i = 0; i < freqValues.length; ++i) {
                newFreqValues[i] = freqValues[targetCategoryIndexNewToOldMap.get(i)];
            }
            frequencies.addAll(Arrays.asList(ArrayUtils.toObject((int[])newFreqValues)));
        } else {
            frequencies.addAll(Arrays.asList(ArrayUtils.toObject((int[])freqValues)));
        }
        return frequencies;
    }

    private JSONArray childrenValue(TreeNode<NodeContent> node, Map<Integer, Integer> targetCategoryIndexNewToOldMap, Map<Integer, Integer> targetCategoryIndexOldToNewMap) {
        TreeNode[] children = node.children();
        if (children == null || children.length == 0) {
            return null;
        }
        JSONArray childrenArray = new JSONArray();
        Arrays.stream(children).forEach(child -> childrenArray.add((Object)this.nodeValue((TreeNode<NodeContent>)child, targetCategoryIndexNewToOldMap, targetCategoryIndexOldToNewMap)));
        return childrenArray;
    }

    private static String splitFieldValue(TreeNode<NodeContent> node) {
        DataColumn splitField = DecisionTree.splitField(node);
        return splitField == null ? null : splitField.getId();
    }

    private static JSONObject splitConditionValue(TreeNode<NodeContent> node) throws JSONException {
        Set splitValues = ((NodeContent)node.content()).splitValues();
        if (splitValues == null) {
            return null;
        }
        OptOrderedJSONObject splitCondition = new OptOrderedJSONObject();
        FieldType fieldType = DecisionTree.splitField(node).getType();
        if (fieldType == FieldType.CATEGORICAL) {
            splitCondition.put("categories", (Collection)TreeJsonBuilder.splitConditionCategoriesValue(splitValues));
        } else if (fieldType == FieldType.NUMERICAL) {
            splitCondition.putOpt("minInclusive", TreeJsonBuilder.splitConditionMinInclusiveValue(node));
            splitCondition.putOpt("maxExclusive", TreeJsonBuilder.splitConditionMaxExclusiveValue(node));
        }
        return splitCondition;
    }

    private static JSONArray splitConditionCategoriesValue(Set<Double> splitValues) {
        JSONArray categories = new JSONArray();
        categories.addAll(splitValues);
        return categories;
    }

    private String formattedValue(double v, TreeNode<NodeContent> node, boolean useGrouping) {
        return NumberFormatter.format((Locale)this.locale, (boolean)useGrouping, (double)v);
    }

    private static Double splitConditionMinInclusiveValue(TreeNode<NodeContent> node) {
        DataColumn column = DecisionTree.splitField(node);
        if (column.getType() == FieldType.CATEGORICAL) {
            return null;
        }
        Range range = TreeJsonBuilder.nodeNumericRange(node);
        return range == null || Double.isInfinite(range.minInclusive()) ? null : Double.valueOf(NumericUtils.round((double)range.minInclusive(), (int)6));
    }

    private static Double splitConditionMaxExclusiveValue(TreeNode<NodeContent> node) {
        Range range = TreeJsonBuilder.nodeNumericRange(node);
        return range == null || Double.isInfinite(range.maxExclusive()) ? null : Double.valueOf(NumericUtils.round((double)range.maxExclusive(), (int)6));
    }

    private static Range nodeNumericRange(TreeNode<NodeContent> node) {
        DataColumn column = DecisionTree.splitField(node);
        if (column.getType() == FieldType.CATEGORICAL) {
            return null;
        }
        List allCategories = column.getCategories();
        return ((NodeContent)node.content()).splitValues().stream().map(v -> (Category)allCategories.get(v.intValue())).filter(c -> !c.special()).map(Category::asBounds).reduce(Range::union).orElse(null);
    }

    private String labelValue(TreeNode<NodeContent> node) {
        DataColumn splitField = DecisionTree.splitField(node);
        if (splitField == null) {
            return null;
        }
        String fieldName = splitField.getLabel();
        if (splitField.getType() == FieldType.CATEGORICAL) {
            return this.categoricalLabelValue(fieldName, node, Integer.MAX_VALUE);
        }
        if (splitField.getType() == FieldType.NUMERICAL) {
            return this.continuousLabelValue(fieldName, node);
        }
        return null;
    }

    private String categoricalLabelValue(String fieldName, TreeNode<NodeContent> node, int maxCategories) {
        List<String> categoryLabels = this.getCategoryLabels(DecisionTree.splitField(node), ((NodeContent)node.content()).splitValues());
        String initStr = !fieldName.isEmpty() ? fieldName + " = " : "";
        StringBuilder label = new StringBuilder(initStr + categoryLabels.get(0));
        int catCount = Math.min(categoryLabels.size(), maxCategories);
        for (int i = 1; i < catCount; ++i) {
            label.append(", ").append(categoryLabels.get(i));
        }
        return label.toString();
    }

    private String continuousLabelValue(String fieldName, TreeNode<NodeContent> node) {
        Double minInclusiveValue = TreeJsonBuilder.splitConditionMinInclusiveValue(node);
        Double maxExclusiveValue = TreeJsonBuilder.splitConditionMaxExclusiveValue(node);
        if (minInclusiveValue == null && maxExclusiveValue == null) {
            Messages messages = Messages.getMessagesFor((String)"Predict_Messages", (Locale)this.locale);
            if (this.isMissing(node).booleanValue()) {
                return messages.get(MessageCode.MISSING_IN_NUMERIC_INPUT_LABEL.name(), new Object[]{fieldName});
            }
            return messages.get(MessageCode.NOTMISSING_IN_NUMERIC_INPUT_LABEL.name(), new Object[]{fieldName});
        }
        if (maxExclusiveValue == null) {
            return fieldName + " \u2265 " + this.formattedValue(minInclusiveValue, node, true);
        }
        if (minInclusiveValue == null) {
            return fieldName + " < " + this.formattedValue(maxExclusiveValue, node, true);
        }
        return this.formattedValue(minInclusiveValue, node, true) + " \u2264 " + fieldName + " < " + this.formattedValue(maxExclusiveValue, node, true);
    }

    private String shortLabelValue(TreeNode<NodeContent> node) {
        DataColumn splitField = DecisionTree.splitField(node);
        if (splitField == null) {
            return null;
        }
        String fieldName = splitField.getLabel();
        if (splitField.getType() == FieldType.CATEGORICAL) {
            return this.categoricalShortLabelValue(fieldName, node);
        }
        if (splitField.getType() == FieldType.NUMERICAL) {
            return this.continuousLabelValue(fieldName, node);
        }
        return null;
    }

    private String categoricalShortLabelValue(String fieldName, TreeNode<NodeContent> node) {
        String shortLabel = this.categoricalLabelValue(fieldName, node, 2);
        List<String> categoryLabels = this.getCategoryLabels(DecisionTree.splitField(node), ((NodeContent)node.content()).splitValues());
        if (categoryLabels.size() > 2) {
            int categoriesLeft = categoryLabels.size() - 2;
            shortLabel = String.format("%s \u2026 (%d others)", shortLabel, categoriesLeft);
        }
        return shortLabel;
    }

    private String shortSplitLabelValue(TreeNode<NodeContent> node) {
        DataColumn splitField = DecisionTree.splitField(node);
        if (splitField == null) {
            return null;
        }
        if (splitField.getType() == FieldType.CATEGORICAL) {
            return this.categoricalShortLabelValue("", node);
        }
        if (splitField.getType() == FieldType.NUMERICAL) {
            return this.continuousShortSplitLabelValue(node);
        }
        return null;
    }

    private String continuousShortSplitLabelValue(TreeNode<NodeContent> node) {
        Double minInclusiveValue = TreeJsonBuilder.splitConditionMinInclusiveValue(node);
        Double maxExclusiveValue = TreeJsonBuilder.splitConditionMaxExclusiveValue(node);
        if (minInclusiveValue == null && maxExclusiveValue == null) {
            Messages messages = Messages.getMessagesFor((String)"Predict_Messages", (Locale)this.locale);
            if (this.isMissing(node).booleanValue()) {
                return messages.get(MessageCode.MISSING_INPUT_SHORT_SPLIT_LABEL.name(), new Object[0]);
            }
            return messages.get(MessageCode.NOTMISSING_INPUT_SHORT_SPLIT_LABEL.name(), new Object[0]);
        }
        if (maxExclusiveValue == null) {
            return "\u2265 " + this.formattedValue(minInclusiveValue, node, false);
        }
        if (minInclusiveValue == null) {
            return "< " + this.formattedValue(maxExclusiveValue, node, false);
        }
        return "[" + this.formattedValue(minInclusiveValue, node, false) + ", " + this.formattedValue(maxExclusiveValue, node, false) + ")";
    }

    private List<String> getCategoryLabels(DataColumn dataColumn, Set<Double> categoryValues) {
        ArrayList<String> categoryLabels = new ArrayList<String>();
        List categories = dataColumn.getCategories();
        for (Double categoryValue : categoryValues) {
            Category category = (Category)categories.get(categoryValue.intValue());
            String label = category.asString(this.locale);
            categoryLabels.add(label);
        }
        return categoryLabels;
    }

    private Boolean isMissing(TreeNode<NodeContent> node) {
        return TreeJsonBuilder.nodeNumericRange(node) == null;
    }

    private Map<Integer, Integer> getTargetCategoryIndexNewToOldMap(Map<Integer, Integer> targetCategoryIndexNewToOldMap) {
        HashMap<Integer, Integer> targetCategoryNewToOldIndexMap = null;
        if (targetCategoryIndexNewToOldMap != null) {
            targetCategoryNewToOldIndexMap = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : targetCategoryIndexNewToOldMap.entrySet()) {
                targetCategoryNewToOldIndexMap.put(entry.getValue(), entry.getKey());
            }
        }
        return targetCategoryNewToOldIndexMap;
    }

    private static class OptOrderedJSONObject
    extends OrderedJSONObject {
        private static final long serialVersionUID = 1L;

        private OptOrderedJSONObject() {
        }

        public JSONObject putOpt(String key, Object value) throws JSONException {
            if (key != null && value != null) {
                this.put(key, value);
            }
            return this;
        }
    }
}

