/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public abstract class KeyDriverFilter {
    protected final double maxPValue;
    protected final int maxDrivers;

    protected KeyDriverFilter(FastPatternContext context) {
        this.maxPValue = context.getDouble("fpd.config.pValueForTests", 0.05);
        this.maxDrivers = context.getInt("fpd.config.maxKeyDriversToReturn", 20);
    }

    public final List<KeyDriver> filterCategorical(List<? extends KeyDriver> drivers) {
        return this.filter(drivers, this::filterCategorical);
    }

    protected boolean filterCategorical(KeyDriver driver) {
        return this.pValueFilter(driver);
    }

    public final List<KeyDriver> filterContinuous(List<? extends KeyDriver> drivers) {
        return this.filter(drivers, this::filterContinuous);
    }

    protected abstract boolean filterContinuous(KeyDriver var1);

    private final List<KeyDriver> filter(List<? extends KeyDriver> drivers, Predicate<KeyDriver> predicate) {
        ArrayList<KeyDriver> result = new ArrayList<KeyDriver>();
        Iterator<? extends KeyDriver> it = drivers.iterator();
        while (it.hasNext() && result.size() < this.maxDrivers) {
            KeyDriver d = it.next();
            if (!predicate.test(d)) continue;
            result.add(d);
        }
        return result;
    }

    protected final boolean pValueFilter(KeyDriver d) {
        return d.getPValue() < this.maxPValue;
    }
}

