/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.algorithm.Algorithm;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriverStatisticsTestFactory;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriverFilter;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayStatisticsTest;
import com.ibm.bi.predict.fastpattern.result.AlgorithmResult;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.stream.Collectors;

public class OneWayKeyDriverAlgorithm
extends Algorithm<AlgorithmResult> {
    private static final Logger LOG = PredictLoggerFactory.getLogger(OneWayKeyDriverAlgorithm.class);
    private final DataFrame dataFrame;
    private List<OneWayKeyDriver> unfiltered;

    public OneWayKeyDriverAlgorithm(DataPrep dataPrep, FastPatternContext context, List<OneWayKeyDriver> oneway) {
        super(dataPrep, context, oneway);
        this.dataFrame = dataPrep.makeFrame();
        OneWayStatisticsTest oneWay = KeyDriverStatisticsTestFactory.createOneWayTest(this.dataFrame, dataPrep.targetColumn().getCategories(), context);
        this.unfiltered = oneWay.getKeyDrivers();
    }

    @Override
    public AlgorithmResult getResults() {
        LOG.perfStart();
        LOG.perfLog("Starting one way key driver computation.");
        List<KeyDriver> topOneWayDrivers = this.filterKeyDrivers(this.unfiltered);
        LOG.perfLog("Finished one way key driver computation.");
        LOG.perfStop();
        return new AlgorithmResult(StatusCode.SUCCESS, topOneWayDrivers);
    }

    public List<OneWayKeyDriver> getUnfilteredResults() {
        return this.unfiltered.stream().filter(v -> !NumericUtils.equals((double)v.getAccuracy(), (double)1.0)).collect(Collectors.toList());
    }

    private List<KeyDriver> filterKeyDrivers(List<OneWayKeyDriver> drivers) {
        OneWayKeyDriverFilter filter = new OneWayKeyDriverFilter(this.context);
        if (this.dataFrame.getFieldType(this.dataFrame.getTargetIndex()) == FieldType.CATEGORICAL) {
            return filter.filterCategorical(drivers);
        }
        return filter.filterContinuous(drivers);
    }
}

