/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriverFilter;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;

class OneWayKeyDriverFilter
extends KeyDriverFilter {
    final double minimumAdjustedR2;

    OneWayKeyDriverFilter(FastPatternContext context) {
        super(context);
        this.minimumAdjustedR2 = context.getDouble("fpd.config.minimumAdjustedRSquared", 0.1);
    }

    @Override
    protected boolean filterCategorical(KeyDriver driver) {
        return this.pValueFilter(driver) && driver.getAccuracy() > this.minimumAdjustedR2;
    }

    @Override
    protected boolean filterContinuous(KeyDriver driver) {
        return this.pValueFilter(driver) && ((OneWayKeyDriver)driver).getStats().getAdjustedRSquared() > this.minimumAdjustedR2;
    }
}

