/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.exceptions.InvalidDataException;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.OneWaySummarizer;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.SummaryStats;
import com.ibm.bi.predict.fastpattern.result.InputField;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OneWayStatisticsTest {
    protected DataFrame df;
    private boolean parallel;
    private FastPatternContext context;
    private final String[] categories;
    private OneWaySummarizer summarizer;

    public OneWayStatisticsTest(DataFrame df, FastPatternContext context) {
        this(df, null, context);
    }

    public OneWayStatisticsTest(DataFrame df, List<Category> categoryList, FastPatternContext context) {
        this.df = df;
        this.context = context;
        this.parallel = context.getBoolean("fpd.config.useParallelProcessing", false);
        this.categories = KeyDriver.toCategoryArray(categoryList, context.getLocale("locale"));
    }

    public void setSummarizer(OneWaySummarizer summarizer) {
        this.summarizer = summarizer;
    }

    public List<OneWayKeyDriver> getKeyDrivers() {
        IntStream stream = IntStream.of(this.df.getDriversIndexes());
        stream = this.parallel ? stream.parallel() : stream;
        return stream.mapToObj(i -> this.getOneWayForFactor(i, this.df.getFieldCategories(i), this.context.getCategoricalChisquareAdjustThreshold(), this.context.getMinCategoryFrequency())).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }

    private OneWayKeyDriver getOneWayForFactor(int factorIndex, int factorCategories, double threshold, int minCategoryFrequency) {
        if (!this.checkCategories(factorCategories)) {
            throw new InvalidDataException("Invalid number of field categories Number of fields = " + factorCategories + " for the field: " + this.df.getFieldName(factorIndex));
        }
        if (!Double.isFinite(factorIndex)) {
            throw new InvalidDataException("Invalid factor index");
        }
        SummaryStats summaryStats = this.summarizer.getSummaryStats(factorIndex, factorCategories, this.df, threshold, minCategoryFrequency);
        return this.createOneWayKeyDriver(factorIndex, summaryStats);
    }

    private boolean checkCategories(int categories) {
        return categories >= this.context.getInt("minCategoriesToBeUseful", 2) && categories <= this.context.getInt("maxCategoriesToProcess", 50);
    }

    private OneWayKeyDriver createOneWayKeyDriver(int factorIndex, SummaryStats summaryStats) {
        String factor = this.df.getFieldName(factorIndex);
        String factorLabel = this.df.getFieldLabel(factorIndex);
        List<InputField> inputFields = InputField.createList(new String[]{factor}, new String[]{factorLabel});
        String id = factor + "_" + this.df.getTargetFieldName() + "_" + this.df.getFieldType(factorIndex).toString().toUpperCase();
        return new OneWayKeyDriver(id, summaryStats, inputFields, factorIndex, this.df.getTargetFieldName(), this.categories, this.context);
    }
}

