/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.TargetField;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.SummaryStats;
import com.ibm.bi.predict.fastpattern.result.InputField;
import com.ibm.bi.predict.fastpattern.util.KeyDriverType;
import java.util.List;
import java.util.Objects;

public class TwoWayKeyDriver
extends KeyDriver {
    private OneWayKeyDriver factor1;
    private OneWayKeyDriver factor2;
    private SummaryStats summaryStats;

    public TwoWayKeyDriver(String id, SummaryStats summaryStats, List<InputField> inputFields, String targetId, OneWayKeyDriver oneway1, OneWayKeyDriver oneway2, FastPatternContext context) {
        this(id, summaryStats, inputFields, targetId, null, oneway1, oneway2, context);
    }

    public TwoWayKeyDriver(String id, SummaryStats summaryStats, List<InputField> inputFields, String targetId, String[] targetCategories, OneWayKeyDriver oneway1, OneWayKeyDriver oneway2, FastPatternContext context) {
        super(id, inputFields, new TargetField(targetId, targetCategories), context);
        this.summaryStats = summaryStats;
        this.factor1 = oneway1;
        this.factor2 = oneway2;
    }

    @Override
    public KeyDriverType getType() {
        return KeyDriverType.TWO_WAY;
    }

    public OneWayKeyDriver getFactor1() {
        return this.factor1;
    }

    public OneWayKeyDriver getFactor2() {
        return this.factor2;
    }

    @Override
    public double getPValue() {
        return this.summaryStats.getPValue();
    }

    public double getAdjustedRSquared() {
        return this.summaryStats.getAdjustedRSquared();
    }

    public double getClassificationAccuracy() {
        return this.summaryStats.getClassificationAccuracy();
    }

    public double getSimpleClassificationAccuracy() {
        return this.summaryStats.getSimpleClassificationAccuracy();
    }

    @Override
    public double getAccuracy() {
        return this.summaryStats.getAccuracy();
    }

    public SummaryStats getStats() {
        return this.summaryStats;
    }

    public String toString() {
        return "\n Two-Way: ID: " + this.id + " - " + this.summaryStats.toString() + ", Factor 1: " + this.factor1.getStats().toString() + ", Factor 2: " + this.factor2.getStats().toString();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof KeyDriver && this.compareTo((KeyDriver)o) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.getAccuracy());
    }
}

