/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers;

import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.algorithm.Algorithm;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriverStatisticsTestFactory;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayKeyDriverFilter;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayStatisticsTest;
import com.ibm.bi.predict.fastpattern.result.AlgorithmResult;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;

public class TwoWayKeyDriverAlgorithm
extends Algorithm<AlgorithmResult> {
    private static final Logger LOG = PredictLoggerFactory.getLogger(TwoWayKeyDriverAlgorithm.class);
    private final DataFrame dataFrame;

    public TwoWayKeyDriverAlgorithm(DataPrep dataPrep, FastPatternContext context, List<OneWayKeyDriver> oneway) {
        super(dataPrep, context, oneway);
        this.dataFrame = dataPrep.makeFrame();
    }

    @Override
    public AlgorithmResult getResults() {
        LOG.perfStart();
        LOG.perfLog("Starting two way key drivers computation.");
        TwoWayStatisticsTest twoWay = KeyDriverStatisticsTestFactory.createTwoWayTest(this.dataFrame, this.dataPrep.targetColumn().getCategories(), this.context, this.oneway);
        List<KeyDriver> topTwoWayDrivers = this.filterKeyDrivers(twoWay.getKeyDrivers());
        LOG.perfLog("Finished two way key drivers computation.");
        LOG.perfStop();
        return new AlgorithmResult(StatusCode.SUCCESS, topTwoWayDrivers);
    }

    private List<KeyDriver> filterKeyDrivers(List<TwoWayKeyDriver> keyDrivers) {
        TwoWayKeyDriverFilter filter = new TwoWayKeyDriverFilter(this.context);
        if (this.dataFrame.getFieldType(this.dataFrame.getTargetIndex()) == FieldType.CATEGORICAL) {
            return filter.filterCategorical(keyDrivers);
        }
        return filter.filterContinuous(keyDrivers);
    }
}

