/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.result;

import com.ibm.bi.predict.exceptions.UnsupportedVersionException;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.result.CaptionedMessage;
import com.ibm.bi.predict.fastpattern.result.FastPatternVersionRanges;
import com.ibm.bi.predict.fastpattern.result.KeyDriverSerializer;
import com.ibm.bi.predict.fastpattern.result.MessageEntry;
import com.ibm.bi.predict.fastpattern.result.TreeResultAnnotator;
import com.ibm.bi.predict.fastpattern.util.KeyDriverType;
import com.ibm.bi.predict.result.DataPrepResult;
import com.ibm.bi.predict.result.ExecutionResult;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.result.Version;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FastPatternResult
extends ExecutionResult<List<KeyDriver>>
implements PredictServiceResponse {
    private static final Logger LOG = PredictLoggerFactory.getLogger(FastPatternResult.class);
    private static final String ID = "id";
    private static final String ERRORS = "errors";
    private static final String PREDICT_STATUS = "predictStatus";
    private static final String RESULTS = "results";
    private static final String STATE = "state";
    private static final String VERSION = "version";
    private static final String VERSION_2 = "2";
    private static final String WARNINGS = "warnings";
    private static final String MESSAGES = "messages";
    private static final String CAPTION = "caption";
    private static final String COLUMNS = "columns";
    private static final String ENTRIES = "entries";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private Version requestedVersion;
    private List<CaptionedMessage> messages = new ArrayList<CaptionedMessage>();

    public FastPatternResult(StatusCode status, List<KeyDriver> keyDrivers, Version reqVersion) {
        super(status, keyDrivers);
        this.requestedVersion = reqVersion;
    }

    public static FastPatternResult build(DataPrepResult dataPrepResult, List<ExecutionResult<List<KeyDriver>>> execResults, Version reqVersion, Locale locale) {
        List<KeyDriver> keyDrivers = FastPatternResult.combineKeyDrivers(execResults);
        if (!keyDrivers.isEmpty()) {
            FastPatternResult.filterTreeIfNotBest(keyDrivers);
        }
        StatusCode status = FastPatternResult.combineStatus(dataPrepResult, execResults);
        FastPatternResult result = new FastPatternResult(status, keyDrivers, reqVersion);
        FastPatternResult.combineMessages(dataPrepResult, execResults, result);
        new TreeResultAnnotator(locale).addMessage(result);
        return result;
    }

    private static List<KeyDriver> filterTreeIfNotBest(List<KeyDriver> keyDrivers) {
        int treeIndex = FastPatternResult.findTreeIndex(keyDrivers);
        if (treeIndex > 0 && keyDrivers.get(treeIndex - 1).getAccuracy() < 1.0) {
            keyDrivers.remove(treeIndex);
        }
        return keyDrivers;
    }

    private static int findTreeIndex(List<KeyDriver> keyDrivers) {
        for (int i = 0; i < keyDrivers.size(); ++i) {
            KeyDriver driver = keyDrivers.get(i);
            if (!driver.getType().equals((Object)KeyDriverType.TREE)) continue;
            return i;
        }
        return -1;
    }

    private static void combineMessages(DataPrepResult dataPrepResult, List<ExecutionResult<List<KeyDriver>>> execResults, FastPatternResult result) {
        result.addErrorMessages(dataPrepResult.getErrorMessages());
        result.addWarningMessages(dataPrepResult.getWarningMessages());
        for (ExecutionResult<List<KeyDriver>> execResult : execResults) {
            result.addErrorMessages(execResult.getErrorMessages());
            result.addWarningMessages(execResult.getWarningMessages());
        }
    }

    private static List<KeyDriver> combineKeyDrivers(List<ExecutionResult<List<KeyDriver>>> execResults) {
        return execResults.stream().map(ExecutionResult::getContent).flatMap(Collection::stream).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private static StatusCode combineStatus(DataPrepResult dataPrepResult, List<ExecutionResult<List<KeyDriver>>> execResults) {
        if (dataPrepResult.getStatus() == StatusCode.FAILURE) {
            return StatusCode.FAILURE;
        }
        for (ExecutionResult<List<KeyDriver>> execResult : execResults) {
            if (execResult.getStatus() != StatusCode.FAILURE) continue;
            return StatusCode.FAILURE;
        }
        return StatusCode.SUCCESS;
    }

    public PredictServiceResponse.HttpStatusCode getResponseCode() {
        if (this.getStatus() == StatusCode.FAILURE) {
            return PredictServiceResponse.HttpStatusCode.ERROR;
        }
        return PredictServiceResponse.HttpStatusCode.SUCCESS;
    }

    public JSONObject getResponseBody() throws JSONException {
        return this.fastPatternResultToJsonResult();
    }

    public List<KeyDriver> getKeyDrivers() {
        return (List)this.getContent();
    }

    public String getVersion() {
        FastPatternVersionRanges versionRange = FastPatternVersionRanges.getInstance();
        if (versionRange.previousIncludes(this.requestedVersion)) {
            return versionRange.previousMax().toString();
        }
        if (versionRange.latestIncludes(this.requestedVersion)) {
            return versionRange.latestMax().toString();
        }
        String message = String.format("Unsupported version. Valid version ranges are: [%s, %s] and [%s, %s]", versionRange.previousMin(), versionRange.previousMax(), versionRange.latestMin(), versionRange.latestMax());
        LOG.error(message);
        throw new UnsupportedVersionException(message);
    }

    private OrderedJSONObject fastPatternResultToJsonResult() throws JSONException {
        try {
            OrderedJSONObject result = new OrderedJSONObject();
            result.put(VERSION, (Object)VERSION_2);
            result.put(PREDICT_STATUS, (Map)this.makeStatus());
            result.put(RESULTS, (Collection)KeyDriverSerializer.serialize((List)this.getContent()));
            return result;
        }
        catch (JSONException e) {
            LOG.error("Error making json response", (Throwable)e);
            throw e;
        }
    }

    private OrderedJSONObject makeStatus() throws JSONException {
        OrderedJSONObject predictStatus = new OrderedJSONObject();
        StatusCode status = this.getStatus();
        predictStatus.put(STATE, (Object)status.name());
        predictStatus.put(ERRORS, (Collection)this.messagesToJSON(this.getErrorMessages()));
        predictStatus.put(WARNINGS, (Collection)this.messagesToJSON(this.getWarningMessages()));
        predictStatus.put(MESSAGES, (Collection)this.captionedMessagesToJSON(this.getMessages()));
        return predictStatus;
    }

    private JSONArray messagesToJSON(List<Message> messages) throws JSONException {
        JSONArray messagesJson = new JSONArray();
        for (Message message : messages) {
            OrderedJSONObject messageJson = new OrderedJSONObject();
            messageJson.put(ID, (Object)message.getMessageCode().name());
            messageJson.put(CAPTION, (Object)message.getCaption());
            messageJson.put(COLUMNS, (Collection)new JSONArray((Collection)message.getColumnIds()));
            messagesJson.add((Object)messageJson);
        }
        return messagesJson;
    }

    private JSONArray captionedMessagesToJSON(List<CaptionedMessage> messages) throws JSONException {
        JSONArray messagesJson = new JSONArray();
        for (CaptionedMessage message : messages) {
            OrderedJSONObject messageJson = new OrderedJSONObject();
            messageJson.put(ID, (Object)message.getId());
            messageJson.put(CAPTION, (Object)message.getCaption());
            JSONArray entriesJson = new JSONArray();
            for (MessageEntry entry : message.getEntries()) {
                JSONObject anEntryJson = new JSONObject();
                anEntryJson.put(SHORT, (Object)entry.getShortMsg());
                anEntryJson.put(LONG, (Object)entry.getLongMsg());
                entriesJson.add((Object)anEntryJson);
            }
            messageJson.put(ENTRIES, (Collection)entriesJson);
            messagesJson.add((Object)messageJson);
        }
        return messagesJson;
    }

    public List<CaptionedMessage> getMessages() {
        return this.messages;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getStatus()).append(this.getContent()).append((Object)this.requestedVersion).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FastPatternResult)) {
            return false;
        }
        FastPatternResult other = (FastPatternResult)((Object)obj);
        return new EqualsBuilder().append((Object)this.getStatus(), (Object)other.getStatus()).append(this.getContent(), other.getContent()).append((Object)this.requestedVersion, (Object)other.requestedVersion).isEquals();
    }
}

