/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.result;

import com.google.common.collect.Iterables;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.fastpattern.chaid.Tree;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.result.InputField;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;

public class KeyDriverSerializer {
    private static final Logger LOG = PredictLoggerFactory.getLogger(KeyDriverSerializer.class);
    private static final String ID = "id";
    private static final String ACCURACY = "accuracy";
    private static final String ACCURACY_LEVEL = "accuracyLevel";
    private static final String CATEGORIES = "categories";
    private static final String DETAILS = "details";
    private static final String FIELDS = "fields";
    private static final String VIS = "vis";
    private static final String IMPORTANCE = "importance";
    private static final String INPUTS = "inputs";
    private static final String LABEL = "label";
    private static final String TARGET = "target";
    private static final String TYPE = "type";

    public static JSONArray serialize(List<KeyDriver> keyDrivers) {
        return KeyDriverSerializer.serializeList(keyDrivers);
    }

    private static JSONArray serializeList(List<KeyDriver> keyDrivers) {
        JSONArray jsonList = new JSONArray();
        keyDrivers.stream().map(KeyDriverSerializer::serializeKeyDriver).forEach(arg_0 -> ((JSONArray)jsonList).add(arg_0));
        return jsonList;
    }

    private static JSONObject serializeKeyDriver(KeyDriver keyDriver) {
        return new JsonBuilder().put(ACCURACY, keyDriver.getAccuracy()).put(ACCURACY_LEVEL, keyDriver.getAccuracyLevel()).put(ID, keyDriver.getId()).put(TYPE, keyDriver.getType().name()).put(FIELDS, KeyDriverSerializer.getFields(keyDriver)).put(VIS, KeyDriverSerializer.getVis(keyDriver)).putIf(DETAILS, keyDriver instanceof Tree, () -> KeyDriverSerializer.getTreeDetails(keyDriver)).build();
    }

    private static JSONObject getFields(KeyDriver keyDriver) {
        return new JsonBuilder().put(TARGET, KeyDriverSerializer.getTargetField(keyDriver)).put(INPUTS, KeyDriverSerializer.getInputFields(keyDriver)).build();
    }

    private static JSONObject getTargetField(KeyDriver keyDriver) {
        return new JsonBuilder().put(ID, keyDriver.getTargetId()).put(LABEL, keyDriver.getTargetId()).putIf(CATEGORIES, ArrayUtils.isNotEmpty((Object[])keyDriver.getTargetCategories()), () -> KeyDriverSerializer.getFieldCategories(keyDriver.getTargetCategories())).build();
    }

    private static JSONArray getInputFields(KeyDriver keyDriver) {
        JSONArray inputFieldJson = new JSONArray();
        keyDriver.getInputFields().stream().map(KeyDriverSerializer::getInputField).forEach(arg_0 -> ((JSONArray)inputFieldJson).add(arg_0));
        return inputFieldJson;
    }

    private static JSONObject getInputField(InputField inputField) {
        return new JsonBuilder().put(ID, inputField.getId()).put(LABEL, inputField.getLabel()).putIf(IMPORTANCE, Double.isFinite(inputField.getImportance()), inputField::getImportance).putIf(CATEGORIES, CollectionUtils.isNotEmpty(inputField.getCategories()), () -> KeyDriverSerializer.getFieldCategories((String[])Iterables.toArray(inputField.getCategories(), String.class))).build();
    }

    private static JSONArray getFieldCategories(String[] categories) {
        JSONArray arr = new JSONArray();
        Arrays.stream(categories).forEach(arg_0 -> ((JSONArray)arr).add(arg_0));
        return arr;
    }

    private static JSONArray getVis(KeyDriver keyDriver) {
        JSONArray visJson = new JSONArray();
        for (VisRecommendation visRecomendation : keyDriver.getVis()) {
            try {
                visJson.add((Object)visRecomendation.toJSON());
            }
            catch (JSONException e) {
                LOG.warn("Error adding vis recommendation to JSON array. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        return visJson;
    }

    private static JSONObject getTreeDetails(KeyDriver keyDriver) {
        return ((Tree)keyDriver).getStructure();
    }

    static class JsonBuilder {
        private JSONObject obj = new JSONObject();

        public JsonBuilder put(String key, Object value) {
            this.tryPut(key, value);
            return this;
        }

        public JsonBuilder putIf(String key, boolean predicate, Supplier<Object> value) {
            if (predicate) {
                this.tryPut(key, value.get());
            }
            return this;
        }

        public JSONObject build() {
            return this.obj;
        }

        private void tryPut(String key, Object value) {
            try {
                this.obj.put(key, value);
            }
            catch (JSONException e) {
                LOG.warn("Error adding key to JSON object. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

