/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.util;

import com.ibm.bi.predict.algorithms.EvaluationStatistic;
import com.ibm.bi.predict.algorithms.tree.util.TreeParameters;
import com.ibm.bi.predict.data.Config;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import java.util.Locale;

public class FastPatternConfig
extends Config {
    private int maxKeyDriversToReturn = 20;
    private boolean useParallelProcessing = false;
    private boolean allowKeyDriverCategoricalTarget = true;
    private int[] driverSearchPairs = new int[]{50, 25};
    private double pValueForTests = 0.05;
    private double minimumAdjustedRSquared = 0.1;
    private EvaluationStatistic accuracyMeasureContTarget = EvaluationStatistic.ADJ_R2;
    private EvaluationStatistic accuracyMeasureCatTarget = EvaluationStatistic.CLASSIFICATION_ACCURACY;
    private double improvementThreshold = 0.1;
    private double moderateAccuracyThreshold = 0.33;
    private double strongAccuracyThreshold = 0.66;
    private TreeParameters categoricalTreeParameters = TreeParameters.categorical();
    private TreeParameters continuousTreeParameters = TreeParameters.continuous();

    public static FastPatternConfig standard() {
        return new FastPatternConfig();
    }

    public FastPatternConfig binCount(int binCount) {
        super.binCount(binCount);
        return this;
    }

    public FastPatternConfig locale(Locale locale) {
        super.locale(locale);
        return this;
    }

    public int[] driverSearchPairs() {
        return this.driverSearchPairs;
    }

    public FastPatternConfig driverSearchPairs(int[] driverSearchPairs) {
        this.driverSearchPairs = driverSearchPairs;
        return this;
    }

    public FastPatternConfig minFrequencyPercent(double minFrequencyPercent) {
        super.minFrequencyPercent(minFrequencyPercent);
        return this;
    }

    public FastPatternConfig maxCategoriesToProcess(int maxCategoriesCount) {
        super.maxCategoriesToProcess(maxCategoriesCount);
        return this;
    }

    public int maxKeyDriversToReturn() {
        return this.maxKeyDriversToReturn;
    }

    public FastPatternConfig maxKeyDriversToReturn(int maxKeyDrivers) {
        this.maxKeyDriversToReturn = maxKeyDrivers;
        return this;
    }

    public FastPatternConfig maxRatioOfUniquesToTotalRows(double maxCategoriesPercentage) {
        super.maxRatioOfUniquesToTotalRows(maxCategoriesPercentage);
        return this;
    }

    public FastPatternConfig minCategoriesToBeUseful(int minCategories) {
        super.minCategoriesToBeUseful(minCategories);
        return this;
    }

    public double minimumAdjustedRSquared() {
        return this.minimumAdjustedRSquared;
    }

    public FastPatternConfig minimumAdjustedRSquared(double adjustedRSquared) {
        this.minimumAdjustedRSquared = adjustedRSquared;
        return this;
    }

    public FastPatternConfig missingValuesInSeparateCategory(boolean binMissingValues) {
        super.missingValuesInSeparateCategory(binMissingValues);
        return this;
    }

    public double pValueForTests() {
        return this.pValueForTests;
    }

    public FastPatternConfig pValueForTests(double pValue) {
        this.pValueForTests = pValue;
        return this;
    }

    public Boolean useParallelProcessing() {
        return this.useParallelProcessing;
    }

    public FastPatternConfig useParallelProcessing(boolean useParallelProcessing) {
        this.useParallelProcessing = useParallelProcessing;
        return this;
    }

    public Boolean getAllowKeyDriverCategoricalTarget() {
        return this.allowKeyDriverCategoricalTarget;
    }

    public FastPatternConfig setAllowKeyDriverCategoricalTarget(boolean allowKeyDriverCategoricalTarget) {
        this.allowKeyDriverCategoricalTarget = allowKeyDriverCategoricalTarget;
        return this;
    }

    public FastPatternConfig treatZeroInflatedAsMissing(boolean zeroInflatedAsMissing) {
        super.treatZeroInflatedAsMissing(zeroInflatedAsMissing);
        return this;
    }

    public EvaluationStatistic accuracyMeasureContTarget() {
        return this.accuracyMeasureContTarget;
    }

    public EvaluationStatistic accuracyMeasureCatTarget() {
        return this.accuracyMeasureCatTarget;
    }

    public FastPatternConfig keyDriverAccuracyMeasure(EvaluationStatistic measure) {
        this.accuracyMeasureContTarget = measure;
        return this;
    }

    public FastPatternConfig handleOutliersInTargetForTests(boolean value) {
        super.handleOutliersInTargetForTests(value);
        return this;
    }

    public double minimumImprovementThreshold() {
        return this.improvementThreshold;
    }

    public double moderateAccuracyThreshold() {
        return this.moderateAccuracyThreshold;
    }

    public double strongAccuracyThreshold() {
        return this.strongAccuracyThreshold;
    }

    public FastPatternConfig setCategoricalTreeParameters(TreeParameters treeParameters) {
        this.categoricalTreeParameters = treeParameters;
        return this;
    }

    public FastPatternConfig setContinuousTreeParameters(TreeParameters treeParameters) {
        this.continuousTreeParameters = treeParameters;
        return this;
    }

    public TreeParameters treeParameters(FieldType target) {
        if (target.equals((Object)FieldType.CATEGORICAL)) {
            return this.categoricalTreeParameters;
        }
        return this.continuousTreeParameters;
    }

    public TreeParameters getCategoricalTreeParameters() {
        return this.categoricalTreeParameters;
    }

    public TreeParameters getContinuousTreeParameters() {
        return this.continuousTreeParameters;
    }
}

