/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.util;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.algorithm.AlgorithmType;
import com.ibm.bi.predict.fastpattern.exceptions.UnparseableParametersException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ParamsUtil {
    private ParamsUtil() {
    }

    public static JSONObject createParams(String moduleId, String tempModuleId, String tempModule, String[] targets, JSONObject analysisScope, int maxFields, boolean joinableFields, boolean alternateFields, boolean shapedModule) throws JSONException {
        JSONObject params = new JSONObject();
        params.put("moduleId", (Object)moduleId);
        params.put("tempModuleId", (Object)tempModuleId);
        params.put("tempModule", (Object)tempModule);
        params.put("targets", (Object[])targets);
        params.put("maxRelevantFields", maxFields);
        params.put("requestId", (Object)"request");
        params.put("getAllJoinableFields", joinableFields);
        params.put("getAlternateFields", alternateFields);
        params.put("shapedModule", shapedModule);
        params.put("analysisScope", (Map)analysisScope);
        params.put("numResults", 10);
        return params;
    }

    public static JSONObject buildParameterObject(DataAccessProvider dataProvider, String targetName, List<String> inputNames, AlgorithmType ... algorithms) throws JSONException {
        JSONObject params = new JSONObject();
        params.put("version", (Object)"1.0.1");
        JSONArray inputs = new JSONArray();
        for (int i = 0; i < dataProvider.getMetaData().fieldCount(); ++i) {
            JSONObject field = new JSONObject();
            String fieldId = dataProvider.getMetaData().getFieldIdentifier(i);
            FieldType type = dataProvider.getMetaData().getFieldType(i);
            String typeStr = type == FieldType.NUMERICAL ? "continuous" : "categorical";
            field.put("id", (Object)fieldId);
            field.put("type", (Object)typeStr);
            if (fieldId.equals(targetName)) {
                params.put("target", (Map)field);
                continue;
            }
            if (inputNames == null) {
                inputs.add((Object)field);
                continue;
            }
            if (!inputNames.contains(fieldId)) continue;
            inputs.add((Object)field);
        }
        params.put("inputs", (Collection)inputs);
        params.put("locale", (Object)"en");
        List algList = Arrays.stream(algorithms).map(algorithm -> algorithm.toString()).collect(Collectors.toList());
        String methods = String.join((CharSequence)",", algList);
        params.put("methods", (Collection)new JSONArray("[" + methods + "]"));
        return params;
    }

    public static JSONObject parseJson(String json) {
        try {
            return (JSONObject)JSON.parse((String)json, (boolean)false);
        }
        catch (Exception e) {
            throw new UnparseableParametersException("Could not parse parameters due to malformed json", e);
        }
    }
}

