/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.json.JsonDataAccessProvider;
import com.ibm.bi.predict.endpoint.PredictServiceRequestsFactory;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.builder.JsonStatToDataSource;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class DataAndParamsRequestFactory
implements PredictServiceRequestsFactory {
    protected static final String BAD_REQUEST_MESSAGE = "The request must have a '%s' and '%s' properties: %s";
    protected static final String DATA_KEY = "data";
    protected static final String PARAMS_KEY = "params";
    protected final PredictContextFactory contextFactory;
    protected final String dataKey;
    protected final String parametersKey;

    public DataAndParamsRequestFactory(PredictContextFactory contextFactory) {
        this(contextFactory, DATA_KEY, PARAMS_KEY);
    }

    public DataAndParamsRequestFactory(PredictContextFactory contextFactory, String dataKey, String parametersKey) {
        this.contextFactory = contextFactory;
        this.dataKey = dataKey;
        this.parametersKey = parametersKey;
    }

    @Override
    public List<PredictServiceRequest> getRequests(JSONObject request, Locale locale, Map<String, Object> extraInfo) {
        try {
            Object data = this.getData(request);
            Object params = this.getParameters(request);
            if (data instanceof JSONObject && params instanceof JSONObject) {
                return this.process((JSONObject)data, (JSONObject)params, locale, extraInfo);
            }
            if (data instanceof JSONObject && params instanceof JSONArray) {
                return this.process((JSONObject)data, (JSONArray)params, locale, extraInfo);
            }
            if (data instanceof JSONArray && params instanceof JSONObject) {
                return this.process((JSONArray)data, (JSONObject)params, locale, extraInfo);
            }
            if (data instanceof JSONArray && params instanceof JSONArray) {
                return this.process((JSONArray)data, (JSONArray)params, locale, extraInfo);
            }
            return this.processOther(data, params, locale, extraInfo);
        }
        catch (Exception e) {
            throw new BadParametersException(String.format(this.exceptionFormat(), this.dataKey, this.parametersKey, e.getMessage()), (Throwable)e);
        }
    }

    protected Object getData(JSONObject request) throws JSONException {
        return request.get(this.dataKey);
    }

    protected Object getParameters(JSONObject request) throws JSONException {
        return request.get(this.parametersKey);
    }

    protected String exceptionFormat() {
        return BAD_REQUEST_MESSAGE;
    }

    protected List<PredictServiceRequest> process(JSONObject data, JSONObject params, Locale locale, Map<String, Object> extraInfo) throws JSONException {
        Tuple<Supplier<DataProvider>, Context> info = this.getRequestInfo(data, params);
        return Collections.singletonList(new PredictServiceRequest((Supplier)info._1, (Context)info._2, locale, extraInfo));
    }

    protected List<PredictServiceRequest> process(JSONObject data, JSONArray params, Locale locale, Map<String, Object> extraInfo) throws JSONException {
        throw new RuntimeException("array of parameters not supported when data is a single object");
    }

    protected List<PredictServiceRequest> process(JSONArray data, JSONObject params, Locale locale, Map<String, Object> extraInfo) throws JSONException {
        ArrayList<PredictServiceRequest> result = new ArrayList<PredictServiceRequest>();
        for (int i = 0; i < data.size(); ++i) {
            Tuple<Supplier<DataProvider>, Context> info = this.getRequestInfo(data.getJSONObject(i), params);
            result.add(new PredictServiceRequest((Supplier)info._1, (Context)info._2, locale, extraInfo));
        }
        return result;
    }

    protected List<PredictServiceRequest> process(JSONArray data, JSONArray params, Locale locale, Map<String, Object> extraInfo) throws JSONException {
        if (data.size() != params.size()) {
            throw new RuntimeException("data and parameters arrays are not the same length");
        }
        ArrayList<PredictServiceRequest> result = new ArrayList<PredictServiceRequest>();
        for (int i = 0; i < data.size(); ++i) {
            Tuple<Supplier<DataProvider>, Context> info = this.getRequestInfo(data.getJSONObject(i), params.getJSONObject(i));
            result.add(new PredictServiceRequest((Supplier)info._1, (Context)info._2, locale, extraInfo));
        }
        return result;
    }

    protected List<PredictServiceRequest> processOther(Object data, Object params, Locale locale, Map<String, Object> extraInfo) throws JSONException {
        throw new RuntimeException("data and parameters must be JSON array or JSON object");
    }

    protected Tuple<Supplier<DataProvider>, Context> getRequestInfo(JSONObject providerObject, JSONObject paramsObject) throws JSONException {
        return new Tuple(this.getProvider(providerObject), (Object)this.contextFactory.make(paramsObject));
    }

    protected Supplier<DataProvider> getProvider(JSONObject json) {
        return () -> this.discoverProviderType(json);
    }

    private DataProvider discoverProviderType(JSONObject json) {
        boolean isJsonStat;
        boolean bl = isJsonStat = json.containsKey((Object)"id") && json.containsKey((Object)"size");
        if (isJsonStat) {
            return DataProvider.fromDataSource((DataSource)new JsonStatToDataSource(json).parse());
        }
        return DataProvider.fromDataAccessProvider((DataAccessProvider)new JsonDataAccessProvider(json));
    }
}

