/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint;

import com.ibm.bi.predict.endpoint.PredictServiceRequestsFactory;
import com.ibm.bi.predict.endpoint.PredictServiceValidator;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.sa.api.error.ErrorResponseBuilder;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.utils.LocaleUtil;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.validation.JsonValidator;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.concurrent.ConcurrentException;

@Api(value="/predict_endpoint", description="Base class for service endpoint.", hidden=true)
public abstract class PredictServiceEndpoint {
    protected abstract String serviceName();

    protected abstract Logger getLogger();

    protected abstract PredictServiceRequestsFactory requestsFactory(Map<String, Object> var1, Locale var2);

    protected abstract PredictServiceFramework serviceFramework(Map<String, Object> var1, Locale var2);

    protected JsonValidator getValidator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="POST from this endpoint")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response postRequest(@ApiParam(name="request", required=true) JSONObject request, @Context HttpServletRequest httpServletRequest, @Context HttpHeaders httpHeaders) throws ConcurrentException {
        Response response;
        Response response2;
        block7: {
            this.getLogger().perfStart();
            this.getLogger().perfLog(String.format("%s: start POST request", this.serviceName()));
            this.getLogger().debug("Request::" + request.toString());
            PredictServiceValidator validator = new PredictServiceValidator(this.getValidator());
            Optional<JSONObject> validationResult = validator.validate(request);
            if (!validationResult.isPresent()) break block7;
            Response response3 = Response.status((int)400).type("application/json").entity((Object)validationResult.get()).build();
            this.getLogger().perfStop(String.format("%s: finished POST request", this.serviceName()));
            return response3;
        }
        try {
            Locale locale = LocaleUtil.getLocale(httpHeaders);
            HashMap<String, Object> extraInfo = new HashMap<String, Object>();
            extraInfo.put("httpServletRequest", httpServletRequest);
            extraInfo.put("httpHeaders", httpHeaders);
            List<PredictServiceRequest> requests = this.requestsFactory(extraInfo, locale).getRequests(request, locale, extraInfo);
            this.getLogger().perfLog(String.format("%s: built requests", this.serviceName()));
            PredictServiceResponse response4 = this.serviceFramework(extraInfo, locale).run(requests, locale);
            this.getLogger().perfLog(String.format("%s: ran service", this.serviceName()));
            JSONObject responseBody = response4.getResponseBody();
            this.getLogger().debug("Response::" + responseBody.toString());
            response2 = Response.status((int)response4.getResponseCode().getCode()).entity((Object)responseBody).build();
        }
        catch (BadParametersException e) {
            this.getLogger().error("{}: Parameters exception {}", new Object[]{this.serviceName(), e.getMessage(), e});
            response = new ErrorResponseBuilder().withStatus(Response.Status.BAD_REQUEST).withDeveloper("BadRequest").withMessage("Error in parameters: " + e.getMessage()).build();
            this.getLogger().perfStop(String.format("%s: finished POST request", this.serviceName()));
            return response;
        }
        catch (Exception e2) {
            this.getLogger().error("{}: Unknown error {}", new Object[]{this.serviceName(), e2.getMessage(), e2});
            response = new ErrorResponseBuilder().withStatus(Response.Status.INTERNAL_SERVER_ERROR).withMessage("Application error: " + e2.getMessage()).build();
            {
                catch (Throwable throwable) {
                    this.getLogger().perfStop(String.format("%s: finished POST request", this.serviceName()));
                    throw throwable;
                }
            }
            this.getLogger().perfStop(String.format("%s: finished POST request", this.serviceName()));
            return response;
        }
        this.getLogger().perfStop(String.format("%s: finished POST request", this.serviceName()));
        return response2;
    }
}

