/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint;

import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.validation.JsonValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class PredictServiceValidator {
    private final JsonValidator validator;

    public PredictServiceValidator(JsonValidator validator) {
        this.validator = validator;
    }

    public Optional<JSONObject> validate(JSONObject request) {
        if (this.validator == null) {
            return Optional.empty();
        }
        try {
            ConstraintImplementation constraints = new ConstraintImplementation();
            if (this.validator.isValid(request, constraints)) {
                return Optional.empty();
            }
            JSONObject result = new JSONObject();
            JSONObject details = new JSONObject();
            details.put("failedValidation", (Collection)new JSONArray(constraints.violations));
            result.put("details", (Map)details);
            return Optional.of(result);
        }
        catch (Exception e) {
            throw new BadParametersException("Validation error: " + e.getMessage(), (Throwable)e);
        }
    }

    static class BuilderImplementation
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private final ConstraintImplementation constraintContext;

        public BuilderImplementation(ConstraintImplementation constraintContext) {
            this.constraintContext = constraintContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return null;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return this.constraintContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String arg0) {
            return null;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int arg0) {
            return null;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String arg0) {
            return null;
        }
    }

    static class ConstraintImplementation
    implements ConstraintValidatorContext {
        private final ConstraintValidatorContext.ConstraintViolationBuilder builder = new BuilderImplementation(this);
        final List<String> violations = new ArrayList<String>();

        public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String parameter) {
            this.violations.add(parameter);
            return this.builder;
        }

        public void disableDefaultConstraintViolation() {
        }

        public String getDefaultConstraintMessageTemplate() {
            return "%s";
        }

        public <T> T unwrap(Class<T> arg0) {
            return null;
        }
    }
}

