/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint.fpd;

import com.ibm.bi.predict.endpoint.PredictServiceEndpoint;
import com.ibm.bi.predict.endpoint.PredictServiceRequestsFactory;
import com.ibm.bi.predict.endpoint.fpd.FastPatternRequestsFactory;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.FastPatternService;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.thirdparty.QueryService;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.wordnik.swagger.annotations.Api;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.Path;

@Api(value="/fast-pattern", description="Fast pattern endpoint.")
@Path(value="fastpattern")
public class FastPatternEndpoint
extends PredictServiceEndpoint {
    private static final Logger log = PredictLoggerFactory.getLogger(FastPatternEndpoint.class);

    @Override
    protected String serviceName() {
        return "fast-pattern-detection-service";
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected PredictServiceRequestsFactory requestsFactory(Map<String, Object> extraInfo, Locale locale) {
        if (!extraInfo.containsKey("httpServletRequest")) {
            throw new BadParametersException("Missing required parameter: httpServletRequest");
        }
        QueryService queryService = new QueryService(extraInfo);
        PredictContextFactory contextFactory = parameters -> new FastPatternContext().loadDataContextProperties(parameters).mixinParameters(parameters);
        return new FastPatternRequestsFactory(contextFactory, queryService);
    }

    @Override
    protected PredictServiceFramework serviceFramework(Map<String, Object> extraInfo, Locale locale) {
        return FastPatternService.getService();
    }
}

