/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint.fpd;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.endpoint.DataAndParamsRequestFactory;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.thirdparty.FieldIdAndType;
import com.ibm.bi.predict.thirdparty.QueryService;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class FastPatternRequestsFactory
extends DataAndParamsRequestFactory {
    private static final Logger logger = PredictLoggerFactory.getLogger(FastPatternRequestsFactory.class);
    private final QueryService queryService;

    public FastPatternRequestsFactory(PredictContextFactory contextFactory, QueryService queryService) {
        super(contextFactory);
        this.queryService = queryService;
    }

    @Override
    public List<PredictServiceRequest> getRequests(JSONObject request, Locale locale, Map<String, Object> extraInfo) {
        if (request.has("data") && request.has("params")) {
            return super.getRequests(request, locale, extraInfo);
        }
        if (request.has("params")) {
            Context context = this.getContext(request);
            return Collections.singletonList(new PredictServiceRequest(this.fetchData(context), context, locale, extraInfo));
        }
        throw new PredictException("Unknown request structure");
    }

    private Supplier<DataProvider> fetchData(Context theContext) {
        FastPatternContext context = (FastPatternContext)theContext;
        return () -> DataProvider.fromDataAccessProvider((DataAccessProvider)this.queryService.getData(context.getDataSetId(), (FieldIdAndType)context.getTarget().get(), (Collection)context.getInputs().get()));
    }

    private Context getContext(JSONObject request) {
        JSONObject params = FastPatternRequestsFactory.getRequiredJSONObject(request, "params");
        try {
            return this.contextFactory.make(params);
        }
        catch (JSONException e) {
            logger.warn("Failed to create relationships context. Reason: " + e.getMessage(), (Throwable)e);
            throw new PredictException("Failed to create relationships context. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONObject getRequiredJSONObject(JSONObject obj, String key) {
        try {
            return obj.getJSONObject(key);
        }
        catch (Exception e) {
            throw new BadParametersException("Required field '" + key + "' missing or not JSONObject", (Throwable)e);
        }
    }
}

