/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint.relationships;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.endpoint.DataAndParamsRequestFactory;
import com.ibm.bi.predict.endpoint.PredictServiceEndpoint;
import com.ibm.bi.predict.endpoint.PredictServiceRequestsFactory;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.explore.service.RelationshipsContext;
import com.ibm.bi.predict.explore.service.RelationshipsContextFactory;
import com.ibm.bi.predict.explore.service.RelationshipsService;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.thirdparty.QueryService;
import com.ibm.bi.predict.utils.JsonUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.wordnik.swagger.annotations.Api;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.Path;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

@Api(value="/relationships", description="manage relationships")
@Path(value="relationships")
public class RelationshipsEndpoint
extends PredictServiceEndpoint {
    private static final Logger logger = PredictLoggerFactory.getLogger(RelationshipsEndpoint.class);

    @Override
    protected String serviceName() {
        return "relationships";
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected PredictServiceRequestsFactory requestsFactory(Map<String, Object> extraInfo, Locale locale) {
        if (!extraInfo.containsKey("httpServletRequest")) {
            throw new BadParametersException("Missing required parameter: httpServletRequest");
        }
        return new RelationshipsRequestFactory((PredictContextFactory)new RelationshipsContextFactory(), new QueryService(extraInfo));
    }

    @Override
    protected PredictServiceFramework serviceFramework(Map<String, Object> extraInfo, Locale locale) {
        return this.makeRelationshipsService(extraInfo);
    }

    private PredictServiceFramework makeRelationshipsService(Map<String, Object> extraInfo) {
        if (!extraInfo.containsKey("httpServletRequest")) {
            throw new BadParametersException("Missing required parameter: httpServletRequest");
        }
        return new RelationshipsService();
    }

    static class RelationshipsRequestFactory
    extends DataAndParamsRequestFactory {
        private final QueryService queryService;

        public RelationshipsRequestFactory(PredictContextFactory contextFactory, QueryService queryService) {
            super(contextFactory);
            this.queryService = queryService;
        }

        @Override
        public List<PredictServiceRequest> getRequests(JSONObject request, Locale locale, Map<String, Object> extraInfo) {
            if (request.has("data") && request.has("params")) {
                return super.getRequests(request, locale, extraInfo);
            }
            if (request.has("params")) {
                Context context = this.getContext(request);
                return Collections.singletonList(new PredictServiceRequest(this.fetchData(context), context, locale, extraInfo));
            }
            throw new PredictException("Unknown request structure");
        }

        private Supplier<DataProvider> fetchData(Context theContext) {
            RelationshipsContext context = (RelationshipsContext)theContext;
            return () -> DataProvider.fromDataAccessProvider((DataAccessProvider)this.queryService.getData(context.getDataSetId(), context.getTarget(), (Collection)context.getCandidates()));
        }

        private Context getContext(JSONObject request) {
            JSONObject params = JsonUtils.getRequiredJSONObject((JSONObject)request, (String)"params");
            try {
                return this.contextFactory.make(params);
            }
            catch (JSONException e) {
                logger.warn("Failed to create relationships context. Reason: " + e.getMessage(), (Throwable)e);
                throw new PredictException("Failed to create relationships context. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

