/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.endpoint.timeseries;

import com.ibm.bi.predict.algorithms.forecasting.hierarchy.Hierarchy;
import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.endpoint.DataAndParamsRequestFactory;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.forecasting.ForecastingContext;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TimeSeriesRequestFactory
extends DataAndParamsRequestFactory {
    private static final Logger logger = PredictLoggerFactory.getLogger(TimeSeriesRequestFactory.class);
    private static final PredictContextFactory noopContextFactory = params -> null;

    public TimeSeriesRequestFactory() {
        this(noopContextFactory);
    }

    public TimeSeriesRequestFactory(PredictContextFactory contextFactory) {
        super(contextFactory);
    }

    @Override
    public List<PredictServiceRequest> getRequests(JSONObject request, Locale locale, Map<String, Object> extraInfo) {
        if (request.has("data") && request.has("params")) {
            return super.getRequests(request, locale, extraInfo).stream().map(req -> this.requestWithContext((PredictServiceRequest)req, request, locale)).collect(Collectors.toList());
        }
        throw new PredictException("Unknown request structure. Request body must contain 'data' and 'params' properties.");
    }

    private PredictServiceRequest requestWithContext(PredictServiceRequest serviceRequest, JSONObject request, Locale locale) {
        return new PredictServiceRequest(serviceRequest.getData(), this.getContext(serviceRequest.getData(), request, locale), serviceRequest.getLocale(), (Map)serviceRequest.getExtraInfo());
    }

    private Context getContext(DataProvider dataProvider, JSONObject request, Locale locale) {
        try {
            return new TimeSeriesContextFactory(dataProvider.asDataSource(), locale).make(JsonHelpers.getObject((JSONObject)request, (String)"params"));
        }
        catch (JSONException e) {
            throw new PredictException("Unexpected error while building context", (Throwable)e);
        }
    }

    static class TimeSeriesContextFactory
    implements PredictContextFactory {
        private final DataSource dataSource;
        private final Locale locale;

        public TimeSeriesContextFactory(DataSource dataSource, Locale locale) {
            this.dataSource = Objects.requireNonNull(dataSource);
            this.locale = locale;
        }

        public Context make(JSONObject parameters) throws JSONException {
            ForecastingContext context = new ForecastingContext().mixinParameters(this.getOptions(parameters));
            Hierarchy timeHierarchy = new Hierarchy(this.getTimeId(), this.getTimeIndices(), Collections.emptyMap());
            context.setTimeHierarchy(timeHierarchy);
            int[] seriesIndices = this.getSeriesIndices();
            if (seriesIndices.length > 0) {
                Hierarchy seriesHierarchy = new Hierarchy(this.getSeriesId(), seriesIndices, Collections.emptyMap());
                context.setSeriesHierarchies(new Hierarchy[]{seriesHierarchy});
            }
            List valueColumns = Arrays.stream(this.getValueIndices()).boxed().collect(Collectors.toList());
            context.setValue("target", valueColumns);
            context.setValue("locale", (Object)this.locale.toString());
            return context;
        }

        private String getTimeId() {
            ColumnMetaData timeField = (ColumnMetaData)this.dataSource.meta().columnMetaData().get(this.getTimeIndices()[0]);
            return timeField.identifier().id().toString();
        }

        private String getSeriesId() {
            int[] seriesIndices = this.getSeriesIndices();
            if (seriesIndices.length == 0) {
                return "";
            }
            ColumnMetaData seriesField = (ColumnMetaData)this.dataSource.meta().columnMetaData().get(seriesIndices[0]);
            return seriesField.identifier().id().toString();
        }

        private int[] getSeriesIndices() {
            return this.fieldIndicesByType(ColumnGroupType.OTHER, ColumnGroupType.METRIC);
        }

        private int[] getValueIndices() {
            return this.fieldIndicesByType(ColumnGroupType.VALUE);
        }

        private int[] getTimeIndices() {
            return this.fieldIndicesByType(ColumnGroupType.TIME);
        }

        private int[] fieldIndicesByType(ColumnGroupType ... types) {
            return ColumnGroup.columnsIndices((List)this.dataSource.groups(), (Enum[])types);
        }

        private JSONObject getOptions(JSONObject params) {
            try {
                JSONObject modelOptions = params.optJSONObject("modelOptions", new JSONObject());
                JSONObject outputOptions = params.optJSONObject("outputOptions", new JSONObject());
                String version = params.getString("version");
                JSONObject options = new JSONObject();
                options.putAll((Map)modelOptions);
                options.putAll((Map)outputOptions);
                options.put("version", (Object)version);
                return options;
            }
            catch (JSONException e) {
                logger.warn("Error while getting options from params - reason={}", (Object)e.getMessage(), (Object)e);
                return new JSONObject();
            }
        }
    }
}

