/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.utils.ParamsUtils;
import com.ibm.bi.predict.utils.ValidatorUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.json.JSONObject;

public class ChartInsightsRequestValidator {
    private static final String DATA = "data";
    private static final String DATASET = "dataset";
    private static final String PARAMS = "params";
    private static final String DATA_ITEMS = "dataItems";
    private static final String VERSION = "version";
    private static final String EDGES = "edges";
    private static final String RESULTS = "results";

    private ChartInsightsRequestValidator() {
    }

    public static boolean isValid(JSONObject inputJson) {
        if (!ChartInsightsRequestValidator.knownRequest(inputJson)) {
            return false;
        }
        return ChartInsightsRequestValidator.missingParams(inputJson).isEmpty();
    }

    public static List<String> missingParams(JSONObject inputJson) {
        if (ChartInsightsRequestValidator.isTreeRequest(inputJson)) {
            return ChartInsightsRequestValidator.verifyTreeParams(inputJson);
        }
        boolean isDataRequest = ChartInsightsRequestValidator.isDataRequest(inputJson);
        if (isDataRequest && ChartInsightsRequestValidator.isV2Data(inputJson)) {
            return ChartInsightsRequestValidator.verifyV2DataParams(inputJson);
        }
        if (isDataRequest) {
            return ChartInsightsRequestValidator.verifyDataParams(inputJson);
        }
        if (ChartInsightsRequestValidator.isDatasetRequest(inputJson)) {
            return ChartInsightsRequestValidator.verifyDatasetParams(inputJson);
        }
        return Collections.emptyList();
    }

    private static boolean knownRequest(JSONObject inputJson) {
        return ChartInsightsRequestValidator.isTreeRequest(inputJson) || ChartInsightsRequestValidator.isDataRequest(inputJson) || ChartInsightsRequestValidator.isDatasetRequest(inputJson);
    }

    private static boolean isTreeRequest(JSONObject inputJSON) {
        return inputJSON.containsKey((Object)RESULTS);
    }

    private static List<String> verifyTreeParams(JSONObject inputJson) {
        List<Object[]> requiredParams = ParamsUtils.paramsList(new Object[][]{ParamsUtils.params(VERSION)});
        return ValidatorUtils.verifyParams(inputJson, requiredParams);
    }

    private static boolean isDataRequest(JSONObject inputJSON) {
        return inputJSON.containsKey((Object)DATA);
    }

    private static boolean isV2Data(JSONObject inputJson) {
        if (!inputJson.containsKey((Object)DATA)) {
            return false;
        }
        JSONObject data = JsonHelpers.getObject((JSONObject)inputJson, (String)DATA);
        return data.containsKey((Object)EDGES) && JsonHelpers.optString((JSONObject)data, (String)VERSION).filter("2"::equals).isPresent();
    }

    private static List<String> verifyDataParams(JSONObject inputJson) {
        List<Object[]> requiredParams = ParamsUtils.paramsList(ParamsUtils.params(DATA, VERSION), ParamsUtils.params(DATA, DATA_ITEMS), ParamsUtils.params(DATA, DATA), ParamsUtils.params(PARAMS));
        return ValidatorUtils.verifyParams(inputJson, requiredParams);
    }

    private static List<String> verifyV2DataParams(JSONObject inputJson) {
        List<Object[]> requiredParams = ParamsUtils.paramsList(ParamsUtils.params(DATA, VERSION), ParamsUtils.params(DATA, EDGES), ParamsUtils.params(DATA, DATA), ParamsUtils.params(PARAMS));
        return ValidatorUtils.verifyParams(inputJson, requiredParams);
    }

    private static boolean isDatasetRequest(JSONObject inputJSON) {
        return inputJSON.containsKey((Object)DATASET);
    }

    private static List<String> verifyDatasetParams(JSONObject inputJson) {
        List<Object[]> requiredParams = ParamsUtils.paramsList(ParamsUtils.params(DATASET), ParamsUtils.params(PARAMS), ParamsUtils.params(DATASET, 0, DATA_ITEMS), ParamsUtils.params(DATASET, 0, DATA));
        return ValidatorUtils.verifyParams(inputJson, requiredParams);
    }
}

