/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.resource;

import com.ibm.bi.predict.explore.nlt.ChartInsights;
import com.ibm.bi.predict.explore.nlt.ChartInsightsRequest;
import com.ibm.bi.predict.explore.resource.ChartInsightsResourceValidator;
import com.ibm.bi.predict.explore.service.ChartInsightServiceFactory;
import com.ibm.bi.predict.sa.api.error.ErrorResponseBuilder;
import com.ibm.bi.predict.utils.LocaleUtil;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.validation.ValidateJson;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONObject;

@Api(value="/chart-insights", description="endpoint for chart insights")
@Path(value="chart-insights")
public class ExploreResource {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ExploreResource.class);
    private final ChartInsightServiceFactory serviceFactory;
    private HttpHeaders httpHeaders;
    private HttpServletRequest httpServletRequest;

    public ExploreResource() {
        this(new ChartInsightServiceFactory());
    }

    public ExploreResource(ChartInsightServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="POST from this endpoint")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response getChartInsights(@ValidateJson(clazz=ChartInsightsResourceValidator.class) @ApiParam(name="request", required=true) JSONObject requestBody) {
        LOGGER.info("Chart Insights request");
        try {
            return this.trySendRequest(requestBody);
        }
        catch (Exception e) {
            LOGGER.error("Unknown error while attempting to generate annotations - error={}", (Object)e.getMessage(), (Object)e);
            return new ErrorResponseBuilder().withStatus(Response.Status.INTERNAL_SERVER_ERROR).withMessage("Unknown application error").build();
        }
    }

    private Response trySendRequest(JSONObject requestBody) {
        try {
            LOGGER.perfStart();
            HashMap<String, Object> httpContext = new HashMap<String, Object>();
            httpContext.put("httpHeaders", this.httpHeaders);
            httpContext.put("httpServletRequest", this.httpServletRequest);
            ChartInsightsRequest request = new ChartInsightsRequest(requestBody, LocaleUtil.getLocale(this.httpHeaders));
            ChartInsights response = this.serviceFactory.make(httpContext).execute(request);
            LOGGER.perfStop("Completed chart insights request");
            JSONObject json = response.toJSON();
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("Unknown error while attempting to generate chart insights - error={}", (Object)e.getMessage(), (Object)e);
            return new ErrorResponseBuilder().withStatus(Response.Status.INTERNAL_SERVER_ERROR).withMessage("Unknown application error").build();
        }
    }

    @Context
    public ExploreResource setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    @Context
    public ExploreResource setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
        return this;
    }
}

