/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.service;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.endorv2.EndorResultSetV2Parser;
import com.ibm.bi.predict.dataaccess.json.JsonDataAccessProvider;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.exceptions.InvalidDataException;
import com.ibm.bi.predict.explore.ChartInsightService;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.ChartInsightsContextFactory;
import com.ibm.bi.predict.explore.RequestCreator;
import com.ibm.bi.predict.explore.nlt.ChartInsightsRequest;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.service.ExploreServiceCaller;
import com.ibm.bi.predict.thirdparty.BIService;
import com.ibm.bi.predict.thirdparty.smarts.RemoteSmartsService;
import com.ibm.bi.predict.thirdparty.smarts.SmartsService;
import com.ibm.bi.predict.types.DataItemType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ChartInsightServiceFactory {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ChartInsightServiceFactory.class);
    private static final String DICTIONARY_KEY = "dictionary";
    private static final String DATAITEMS_KEY = "dataItems";
    private static final String DATA_ITEM_TYPES_KEY = "dataItemsTypes";

    public ExploreServiceCaller make(Map<String, Object> context) {
        BIService biService = new BIService(context);
        return this.make((SmartsService)new RemoteSmartsService(biService));
    }

    public ExploreServiceCaller make(SmartsService smartsService) {
        return new ExploreServiceCaller(new ChartInsightService(), chartInsightsRequest -> ChartInsightServiceFactory.makeChartInsightsRequestFromJSONRequest(chartInsightsRequest, smartsService));
    }

    static List<Request> makeChartInsightsRequestFromJSONRequest(ChartInsightsRequest request, SmartsService smartsService) {
        ChartInsightServiceFactory.validateRequest(request);
        if (request.isTreeRequest()) {
            return Collections.singletonList(RequestCreator.create((JSONObject)request.fullRequest(), (Locale)request.locale()));
        }
        if (request.hasMultipleDataSets()) {
            return ChartInsightServiceFactory.getRequestForMultipleDataSets(request, smartsService);
        }
        return Collections.singletonList(ChartInsightServiceFactory.getRequestForSingleDataSet(request, smartsService));
    }

    private static void validateRequest(ChartInsightsRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must be non-null");
        }
        JSONObject fullJson = request.fullRequest();
        if (fullJson == null) {
            throw new InvalidDataException("Null request");
        }
        if (!(JsonHelpers.hasArrayKey((JSONObject)fullJson, (String)"dataset") || JsonHelpers.hasObjectKey((JSONObject)fullJson, (String)"data") || JsonHelpers.hasArrayKey((JSONObject)fullJson, (String)"results"))) {
            throw new InvalidDataException("Missing required dataset, data, or results property");
        }
        if (JsonHelpers.hasArrayKey((JSONObject)fullJson, (String)"dataset") && !JsonHelpers.hasArrayKey((JSONObject)fullJson, (String)"params") && !JsonHelpers.hasObjectKey((JSONObject)fullJson, (String)"params")) {
            throw new InvalidDataException("Missing required params");
        }
        if (JsonHelpers.hasObjectKey((JSONObject)fullJson, (String)"data") && !JsonHelpers.hasObjectKey((JSONObject)fullJson, (String)"params")) {
            throw new InvalidDataException("Missing required params");
        }
    }

    private static Request getRequestForSingleDataSet(ChartInsightsRequest request, SmartsService smartsService) {
        return ChartInsightServiceFactory.makeRequest(request.data(), request.params(), request.locale(), smartsService);
    }

    private static List<Request> getRequestForMultipleDataSets(ChartInsightsRequest request, SmartsService smartsService) {
        ArrayList<Request> requests = new ArrayList<Request>();
        for (int i = 0; i < request.numDataSets(); ++i) {
            requests.add(ChartInsightServiceFactory.makeRequest(request.data(i), request.params(i), request.locale(), smartsService));
        }
        return requests;
    }

    private static Request makeRequest(JSONObject data, JSONObject params, Locale locale, SmartsService smartsService) {
        ChartInsightsContext context = ChartInsightsContextFactory.makeFromJson((JSONObject)params).setSmartsService(smartsService);
        return RequestCreator.create((DataAccessProvider)ChartInsightServiceFactory.getDataAccessProvider(data, params), (ChartInsightsContext)context, (Locale)locale);
    }

    private static DataAccessProvider getDataAccessProvider(JSONObject data, JSONObject params) {
        return EndorResultSetV2Parser.isV2Data((JSONObject)data) ? new EndorResultSetV2Parser(data, params).toDataAccessProvider() : new JsonDataAccessProvider(data, ChartInsightServiceFactory.getDataTypeMapFromParams(params), Collections.emptyMap());
    }

    protected static Map<String, String> getDataTypeMapFromParams(JSONObject params) {
        if (params == null) {
            return Collections.emptyMap();
        }
        try {
            JSONObject dictionary = params.getJSONObject(DICTIONARY_KEY);
            if (!dictionary.containsKey((Object)DATA_ITEM_TYPES_KEY)) {
                return Collections.emptyMap();
            }
            JSONArray dataItems = dictionary.getJSONArray(DATAITEMS_KEY);
            JSONArray dataItemTypes = dictionary.getJSONArray(DATA_ITEM_TYPES_KEY);
            HashMap<String, String> typeMap = new HashMap<String, String>();
            for (int i = 0; i < dataItems.size(); ++i) {
                DataItemType dataItemType = DataItemType.fromString((String)dataItemTypes.getString(i));
                typeMap.put(dataItems.getString(i), dataItemType.toFieldType().toString());
            }
            return typeMap;
        }
        catch (JSONException e) {
            LOG.warn("JSONException while trying to read params object - reason={}", (Object)e.getLocalizedMessage());
            return Collections.emptyMap();
        }
    }
}

