/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.frf.resource;

import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldsResult;
import com.ibm.bi.predict.frf.resource.FRFResourceValidator;
import com.ibm.bi.predict.frf.service.FRFServiceFactory;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.sa.api.error.ErrorResponseBuilder;
import com.ibm.bi.predict.utils.LocaleUtil;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.validation.ValidateJson;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.concurrent.ConcurrentException;

@Api(value="/recommendations", description="endpoint for FRF-Resources")
@Path(value="recommendations")
public class FRFResource {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(FRFResource.class);
    private FRFServiceFactory serviceFactory;

    public FRFResource() {
        this(new FRFServiceFactory());
    }

    public FRFResource(FRFServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="POST from this endpoint")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response getRecommendations(@ValidateJson(clazz=FRFResourceValidator.class) @ApiParam(name="request", required=true) JSONObject request, @Context HttpServletRequest httpServletRequest, @Context HttpHeaders httpHeaders) throws ConcurrentException {
        LOGGER.info("Fast Relevant Field Service POST request");
        try {
            Message msg;
            LOGGER.perfStart();
            long t = System.currentTimeMillis();
            Locale locale = LocaleUtil.getLocale(httpHeaders);
            FRFContext context = new FRFContext();
            HashMap<String, Object> httpContext = new HashMap<String, Object>();
            httpContext.put("httpHeaders", httpHeaders);
            httpContext.put("httpServletRequest", httpServletRequest);
            context.mixin(request, locale, httpContext);
            LOGGER.debug(String.format("%s: FRFResource build inputs %d ms", context.identifierPrefix(), System.currentTimeMillis() - t));
            t = System.currentTimeMillis();
            RelevantFieldsResult response = this.serviceFactory.make().execute(context);
            LOGGER.perfStop("Completed FRF recommendation request");
            LOGGER.debug(String.format("%s: FRFResource run service %d ms", context.identifierPrefix(), System.currentTimeMillis() - t));
            JSONObject json = response.toJSON();
            List errorMessages = response.getErrorMessages();
            if (errorMessages != null && !errorMessages.isEmpty() && (msg = (Message)errorMessages.get(0)).getMessageCode() == MessageCode.FRF_50_SERVICE_ERROR) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)json).build();
            }
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("Unknown error while attempting to get FRF recommendations - error={}", (Object)e.getMessage(), (Object)e);
            return new ErrorResponseBuilder().withStatus(Response.Status.INTERNAL_SERVER_ERROR).withMessage("Unknown application error").build();
        }
    }
}

