/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.insights;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.endpoint.DataAndParamsRequestFactory;
import com.ibm.bi.predict.endpoint.PredictServiceEndpoint;
import com.ibm.bi.predict.endpoint.PredictServiceRequestsFactory;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.ChartInsightService;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.ChartInsightsContextFactory;
import com.ibm.bi.predict.explore.resource.ChartInsightsResourceValidator;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.validation.JsonValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.Path;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

@Path(value="chart-insights")
public class ChartInsightsEndpoint
extends PredictServiceEndpoint {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ChartInsightsEndpoint.class);

    @Override
    protected String serviceName() {
        return "chart-insights";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected PredictServiceRequestsFactory requestsFactory(Map<String, Object> extraInfo, Locale locale) {
        return new ChartInsightsRequestsFactory();
    }

    @Override
    protected PredictServiceFramework serviceFramework(Map<String, Object> extraInfo, Locale locale) {
        return new ChartInsightService();
    }

    @Override
    protected JsonValidator getValidator() {
        return new ChartInsightsResourceValidator();
    }

    static class ChartInsightsRequestsFactory
    extends DataAndParamsRequestFactory {
        public ChartInsightsRequestsFactory() {
            super((PredictContextFactory)new ChartInsightsContextFactory());
        }

        @Override
        public List<PredictServiceRequest> getRequests(JSONObject request, Locale locale, Map<String, Object> extraInfo) {
            if (request.containsKey((Object)"results")) {
                return this.getTreeRequest(request, locale, extraInfo);
            }
            return super.getRequests(request, locale, extraInfo);
        }

        @Override
        public Object getData(JSONObject request) throws JSONException {
            if (request.containsKey((Object)"data")) {
                return request.get("data");
            }
            if (request.containsKey((Object)"dataset")) {
                return request.get("dataset");
            }
            throw new BadParametersException("Request must have 'data' or 'dataset'");
        }

        private List<PredictServiceRequest> getTreeRequest(JSONObject request, Locale locale, Map<String, Object> extraInfo) {
            ChartInsightsContext context = new ChartInsightsContext();
            context.setTree(request);
            return Collections.singletonList(new PredictServiceRequest(() -> null, (Context)context, locale, extraInfo));
        }
    }
}

