/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.api.error;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ErrorResponseBuilder {
    private Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
    private String contentType = "application/json";
    private JSONObject entity = new JSONObject();
    private String developer = "InternalServerError";
    private String level = "error";
    private String message = "Unknown error";
    private static final Logger log = PredictLoggerFactory.getLogger(ErrorResponseBuilder.class);

    public ErrorResponseBuilder withStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public ErrorResponseBuilder withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ErrorResponseBuilder withDeveloper(String developerMessage) {
        this.developer = developerMessage;
        return this;
    }

    public ErrorResponseBuilder withLevel(String level) {
        this.level = level;
        return this;
    }

    public ErrorResponseBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public Response build() {
        try {
            this.entity.put("code", this.status.getStatusCode());
            this.entity.put("developer", (Object)this.developer);
            this.entity.put("level", (Object)this.level);
            this.entity.put("message", (Object)this.message);
            return Response.status((Response.Status)this.status).type(this.contentType).entity((Object)this.entity).build();
        }
        catch (JSONException e) {
            log.debug("Unble to get error response details", (Throwable)e);
            return Response.status((Response.Status)this.status).type(this.contentType).entity((Object)new JSONObject()).build();
        }
    }
}

