/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.api.error;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.ibm.bi.predict.sa.api.error.ErrorResponseBuilder;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Logger logger = PredictLoggerFactory.getLogger(JsonProcessingExceptionMapper.class);

    public Response toResponse(JsonProcessingException e) {
        logger.info("Received JsonProcessingException while parsing input - message={}", (Object)e.getMessage());
        ErrorResponseBuilder responseBuilder = new ErrorResponseBuilder();
        if (e instanceof UnrecognizedPropertyException || e instanceof JsonMappingException) {
            return this.badRequest(responseBuilder).withMessage(this.getMessageForException(e)).build();
        }
        return responseBuilder.withStatus(Response.Status.BAD_REQUEST).withDeveloper("InvalidRequestError").build();
    }

    private ErrorResponseBuilder badRequest(ErrorResponseBuilder responseBuilder) {
        return responseBuilder.withStatus(Response.Status.BAD_REQUEST).withDeveloper("InvalidRequestError");
    }

    private String getMessageForException(JsonProcessingException e) {
        if (e instanceof UnrecognizedPropertyException) {
            return String.format("Unrecognized property: %s", this.getUnrecognizedPath((UnrecognizedPropertyException)e));
        }
        if (e instanceof JsonMappingException) {
            return "Invalid JSON input";
        }
        return "Unknown error";
    }

    private String getUnrecognizedPath(UnrecognizedPropertyException e) {
        String unrecognizedPath = e.getPath().stream().map(r -> r.getFieldName()).filter(Objects::nonNull).collect(Collectors.joining("->"));
        return unrecognizedPath;
    }
}

