/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.resource;

import com.ibm.bi.predict.sa.api.error.ErrorResponseBuilder;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.sa.execution.resource.ExecutionResourceValidator;
import com.ibm.bi.predict.sa.suggestion.service.ExecutionServiceGateway;
import com.ibm.bi.predict.utils.LocaleUtil;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.validation.ValidateJson;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.concurrent.ConcurrentException;

@Path(value="executions")
public class ExecutionResource {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ExecutionResource.class);
    private final ExecutionServiceGateway.Factory executionServiceFactory;

    public ExecutionResource() {
        this(new ExecutionServiceGateway.Factory());
    }

    public ExecutionResource(ExecutionServiceGateway.Factory executionServiceFactory) {
        this.executionServiceFactory = executionServiceFactory;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getRoot() {
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAnnotations(@ValidateJson(clazz=ExecutionResourceValidator.class) JSONObject request, @Context HttpHeaders httpHeaders) throws ConcurrentException {
        LOG.info("Handling annotations execution request");
        try {
            Locale locale = LocaleUtil.getLocale(httpHeaders);
            return this.trySendRequest(request, locale);
        }
        catch (IllegalArgumentException e) {
            LOG.error("IllegalArgumentException while attempting to generate annotations - error={}", (Object)e.getMessage(), (Object)e);
            return new ErrorResponseBuilder().withStatus(Response.Status.BAD_REQUEST).withMessage("Bad input request").build();
        }
        catch (Exception e) {
            LOG.error("Unknown error while attempting to generate annotations - error={}", (Object)e.getMessage(), (Object)e);
            return new ErrorResponseBuilder().withStatus(Response.Status.INTERNAL_SERVER_ERROR).withMessage("Unknown application error").build();
        }
    }

    private Response trySendRequest(JSONObject request, Locale locale) throws ConcurrentException, JSONException {
        LOG.perfStart();
        LOG.info("Executing annotations for request");
        LOG.debug("Request::" + request.toString());
        ExecutionResponse response = this.executionServiceFactory.make().executeRequest(request, locale);
        LOG.perfStop("Completed execution request");
        LOG.info("Completed execution request");
        JSONObject responseData = this.buildResponse(request, response);
        return Response.ok((Object)responseData, (String)"application/json").build();
    }

    private JSONObject buildResponse(JSONObject request, ExecutionResponse response) throws JSONException {
        LOG.debug("Building execution response, response={}", (Object)response);
        return response.getResponseBody();
    }
}

