/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.resource;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.validation.JsonValidator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ExecutionResourceValidator
implements JsonValidator {
    private final Logger logger = PredictLoggerFactory.getLogger(ExecutionResourceValidator.class);

    @Override
    public boolean isValid(JSONObject inputJson, ConstraintValidatorContext context) {
        if (inputJson == null) {
            return false;
        }
        List<String> missingParams = this.verifyRequiredParams(inputJson);
        if (!missingParams.isEmpty()) {
            this.addValidationFailReason(missingParams, context);
        }
        return missingParams.isEmpty();
    }

    private List<String> verifyRequiredParams(JSONObject inputJson) {
        List<String[]> requiredParams = inputJson.containsKey((Object)"data") ? this.getRequiredParamsForTopLevelData() : this.getRequiredParamsForTopLevelDataSet();
        List<String> missingParams = requiredParams.stream().filter(p -> !this.exists(inputJson, (String)p)).map(p -> String.join((CharSequence)".", p)).collect(Collectors.toList());
        return missingParams;
    }

    private void addValidationFailReason(List<String> missingParams, ConstraintValidatorContext context) {
        if (context == null) {
            return;
        }
        missingParams.forEach(param -> context.buildConstraintViolationWithTemplate(param).addConstraintViolation());
    }

    private List<String[]> getRequiredParamsForTopLevelDataSet() {
        return this.paramsList(this.params("dataset"), this.params("params"), this.params("dataset", "data"), this.params("dataset", "dataItems"), this.params("dataset", "datasetId"), this.params("params", "annotations"));
    }

    private List<String[]> getRequiredParamsForTopLevelData() {
        return this.paramsList(this.params("data"), this.params("params"), this.params("data", "dataItems"), this.params("params", "annotations"));
    }

    private String[] params(String ... keys) {
        return keys;
    }

    private List<String[]> paramsList(String[] ... params) {
        return Arrays.asList(params);
    }

    private boolean exists(JSONObject inputJson, String ... keys) {
        if (inputJson == null) {
            return false;
        }
        if (keys.length == 1) {
            return inputJson.containsKey((Object)keys[0]);
        }
        JSONObject head = inputJson;
        for (int i = 0; i < keys.length - 1; ++i) {
            if (!inputJson.containsKey((Object)keys[i])) {
                return false;
            }
            try {
                Object o = inputJson.get(keys[i]);
                if (o instanceof JSONObject) {
                    head = (JSONObject)o;
                    continue;
                }
                if (!(o instanceof JSONArray)) continue;
                JSONArray a = (JSONArray)o;
                return this.existsArray(a, keys[1]);
            }
            catch (JSONException e) {
                this.logger.warn("JSON exception while checking for existence - message={}", (Object)e.getMessage(), (Object)e);
            }
        }
        return head.containsKey((Object)keys[keys.length - 1]);
    }

    private boolean existsArray(JSONArray a, String key) throws JSONException {
        for (int j = 0; j < a.size(); ++j) {
            if (!this.exists(a.getJSONObject(j), key)) continue;
            return true;
        }
        return false;
    }
}

