/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.api.resource;

import com.ibm.bi.predict.sa.api.error.ErrorResponseBuilder;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationService;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationServiceFactory;
import com.ibm.bi.predict.sa.utils.LogDataCleanser;
import com.ibm.bi.predict.utils.LocaleUtil;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Locale;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONException;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

@Path(value="annotations")
public class AnnotationsResource {
    private static final Logger logger = PredictLoggerFactory.getLogger(AnnotationsResource.class);
    private AnnotationServiceFactory serviceFactory;
    private LazyInitializer<AnnotationService> annotationService = new LazyInitializer<AnnotationService>(){

        protected AnnotationService initialize() throws ConcurrentException {
            return AnnotationsResource.this.serviceFactory.getAnnotationService();
        }
    };

    public AnnotationsResource() {
        this.serviceFactory = new AnnotationServiceFactory();
    }

    public AnnotationsResource(AnnotationServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getRoot() throws ConcurrentException {
        return Response.status((int)200).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAnnotations(@Valid AnnotationRequest request, @Context HttpHeaders httpHeaders) throws ConcurrentException {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling annotations request - use={}, data={}", (Object)request.getUse(), LogDataCleanser.cleanseDataForLogging(request));
        } else {
            logger.info("Handling annotations request");
        }
        try {
            Locale locale = LocaleUtil.getLocale(httpHeaders);
            return this.trySendRequest(request, locale);
        }
        catch (Exception e) {
            logger.error("Unknown error while attempting to suggest annotations - error={}", (Object)e.getMessage(), (Object)e);
            return new ErrorResponseBuilder().withStatus(Response.Status.INTERNAL_SERVER_ERROR).withMessage("Unknown application error").build();
        }
    }

    private Response trySendRequest(AnnotationRequest request, Locale locale) throws ConcurrentException, JSONException {
        logger.perfStart();
        logger.info("Getting list of suitable annotations for request");
        Annotations annotations = ((AnnotationService)this.annotationService.get()).getSuitableAnnotations(request, locale);
        logger.perfLog("Completed annotation suggestion request");
        logger.perfStop();
        if (logger.isDebugEnabled()) {
            logger.debug("Completed annotation suggestion request - annotations={}", (Object)annotations);
        } else {
            logger.info("Completed annotation suggestion request");
        }
        return Response.ok().entity((Object)annotations.getResponseBody()).type("application/json").build();
    }
}

