/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.utils;

import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class LogDataCleanser {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(LogDataCleanser.class);

    private LogDataCleanser() {
    }

    public static List<AnnotationData> cleanseDataForLogging(AnnotationRequest request) {
        if (request.getData() != null) {
            return request.getData().stream().map(ad -> new AnnotationData(ad.getId(), LogDataCleanser.copyDataItems(ad))).collect(Collectors.toList());
        }
        LOGGER.debug("No data found in request");
        return Collections.emptyList();
    }

    private static List<DataItem> copyDataItems(AnnotationData ad) {
        return ad.getDataItems().stream().map(LogDataCleanser::copyDataItem).collect(Collectors.toList());
    }

    private static DataItem copyDataItem(DataItem di) {
        DataItem copiedDataItem = new DataItem();
        copiedDataItem.setId(di.getId());
        copiedDataItem.setItemId("");
        copiedDataItem.setType(di.getType());
        copiedDataItem.setAggregate(di.getAggregate());
        return copiedDataItem;
    }
}

