/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;

public class LocaleUtil {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(LocaleUtil.class);
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String CRN = "CRN";
    private static final String PRODUCT_LOCALE = "productLocale";

    private LocaleUtil() {
    }

    public static Locale getLocale(HttpHeaders httpHeaders) {
        Map cookies = httpHeaders.getCookies();
        Optional<Locale> userLocale = cookies.containsKey(CRN) ? LocaleUtil.getLocaleFromCookie((Cookie)cookies.get(CRN)) : LocaleUtil.getLocaleFromAcceptableLanguages(httpHeaders);
        return userLocale.orElse(DEFAULT_LOCALE);
    }

    private static Optional<Locale> getLocaleFromCookie(Cookie cookie) {
        try {
            String cookieString = URLDecoder.decode(cookie.getValue(), StandardCharsets.UTF_8.name());
            Map<String, String> parsed = LocaleUtil.parseCookieString(cookieString);
            return Optional.ofNullable(LocaleUtil.stringToLocale(parsed.get(PRODUCT_LOCALE)));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.debug("Failed getting locale from cookie, using default", (Throwable)e);
            return Optional.of(DEFAULT_LOCALE);
        }
    }

    private static Optional<Locale> getLocaleFromAcceptableLanguages(HttpHeaders httpHeaders) {
        List locales = httpHeaders.getAcceptableLanguages();
        if (locales.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(LocaleUtil.stringToLocale(((Locale)locales.get(0)).getLanguage()));
    }

    private static Map<String, String> parseCookieString(String cookieString) {
        return Pattern.compile("&").splitAsStream(cookieString).map(c -> c.split("=")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
    }

    private static Locale stringToLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        return Locale.forLanguageTag(localeString);
    }
}

