/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ValidatorUtils {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ValidatorUtils.class);

    private ValidatorUtils() {
    }

    public static List<String> verifyParams(JSONObject inputJson, List<Object[]> requiredParams) {
        List<String> missingParams = requiredParams.stream().filter(p -> !ValidatorUtils.exists(inputJson, p)).map(p -> ValidatorUtils.stringify(p)).collect(Collectors.toList());
        return missingParams;
    }

    private static String stringify(Object ... p) {
        List<String> l = Arrays.asList(p).stream().map(v -> v.toString()).collect(Collectors.toList());
        return String.join((CharSequence)".", l.toArray(new String[l.size()]));
    }

    private static boolean exists(JSONObject inputJson, Object ... keys) {
        if (inputJson == null) {
            return false;
        }
        try {
            if (keys.length == 1) {
                return ValidatorUtils.validateJsonData(inputJson, (String)keys[0]);
            }
            Object head = ValidatorUtils.getInputJsonHead(inputJson, keys);
            return ValidatorUtils.validateJsonData((JSONObject)head, (String)keys[keys.length - 1]);
        }
        catch (Exception e) {
            LOGGER.warn("Error while attempting to validate JSON, error: ", (Throwable)e);
            return false;
        }
    }

    public static boolean checkExistenceBasedOnInput(JSONObject inputJson, JSONObject head, int i, String ... keys) {
        try {
            Object o = inputJson.get(keys[i]);
            if (o instanceof JSONObject) {
                JSONObject newHead = (JSONObject)o;
                return newHead.containsKey((Object)keys[keys.length - 1]);
            }
            if (o instanceof JSONArray) {
                return ValidatorUtils.existsArray((JSONArray)o, keys[1]);
            }
        }
        catch (JSONException e) {
            LOGGER.warn("JSON exception while checking for existence - message={}", (Object)e.getMessage(), (Object)e);
        }
        return head.containsKey((Object)keys[keys.length - 1]);
    }

    private static boolean existsArray(JSONArray o, String key) throws JSONException {
        for (int j = 0; j < o.size(); ++j) {
            if (ValidatorUtils.exists(o.getJSONObject(j), key)) continue;
            return false;
        }
        return true;
    }

    private static Object getInputJsonHead(JSONObject inputJson, Object ... keys) {
        Object head = inputJson;
        for (int i = 0; i < keys.length - 1; ++i) {
            head = keys[i] instanceof String ? head.get(keys[i]) : ((JSONArray)head).get(((Integer)keys[i]).intValue());
        }
        return head;
    }

    private static boolean validateJsonData(JSONObject inputJson, String key) {
        Object value;
        if (!inputJson.containsKey((Object)key)) {
            return false;
        }
        try {
            value = inputJson.get(key);
        }
        catch (JSONException e) {
            LOGGER.warn("Error parsing inputJson", (Throwable)e);
            return false;
        }
        return ValidatorUtils.isObjectEmpty(value);
    }

    private static boolean isObjectEmpty(Object value) {
        if (value instanceof JSONArray) {
            return ValidatorUtils.isJsonArrayEmpty(value);
        }
        if (value instanceof JSONObject) {
            return ValidatorUtils.isJsonObjectEmpty(value);
        }
        if (value instanceof String) {
            return ValidatorUtils.isJsonStringEmpty(value);
        }
        return true;
    }

    private static boolean isJsonArrayEmpty(Object value) {
        JSONArray jsonArray = (JSONArray)value;
        return !jsonArray.isEmpty();
    }

    private static boolean isJsonObjectEmpty(Object value) {
        JSONObject jsonObject = (JSONObject)value;
        return !jsonObject.isEmpty();
    }

    private static boolean isJsonStringEmpty(Object value) {
        String jsonString = (String)value;
        return !jsonString.isEmpty();
    }
}

