/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.validation;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.validation.JsonValidator;
import com.ibm.bi.predict.validation.ValidateJson;
import java.util.Optional;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.json.JSONObject;

public class ResourceValidator
implements ConstraintValidator<ValidateJson, JSONObject> {
    private static final Logger logger = PredictLoggerFactory.getLogger(ResourceValidator.class);
    private JsonValidator validator;

    public void initialize(ValidateJson validJsonAnnotation) {
        Optional<JsonValidator> instance = this.getInstanceOfValidator(validJsonAnnotation.clazz());
        if (instance.isPresent()) {
            this.validator = instance.get();
        } else {
            logger.warn("Failed to create validation class. No validation being performed - clazz={}", (Object)validJsonAnnotation.clazz().getCanonicalName());
            this.validator = new JsonValidator(){};
        }
    }

    public boolean isValid(JSONObject inputJson, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        return this.validator.isValid(inputJson, context);
    }

    public JsonValidator getValidator() {
        return this.validator;
    }

    private Optional<JsonValidator> getInstanceOfValidator(Class<? extends JsonValidator> clazz) {
        try {
            return Optional.of(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Error while attempting to create an instance of the validation class - error={}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }
}

