/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting;

import com.ibm.bi.predict.math.NumericUtils;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

public class AutoCorrelationFunction {
    private double[] data;
    private double[] acf;

    public static AutoCorrelationFunction calculateOnDetrendedSeries(double[] y, int max) {
        int smoothWindow = Math.min(max, y.length / 10);
        double[] detrended = NumericUtils.movingAverageSmooth((double[])y, (int)y.length, (int)smoothWindow);
        for (int i = 0; i < detrended.length; ++i) {
            detrended[i] = y[i] - detrended[i];
        }
        return new AutoCorrelationFunction(detrended, max);
    }

    public AutoCorrelationFunction(double[] series, int lags) {
        if (lags >= series.length) {
            throw new IllegalArgumentException("Cannot request lags beyond the length of the data");
        }
        double mean = NumericUtils.mean((double[])series);
        this.data = new double[series.length];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = series[i2] - mean;
        }
        if (Double.isNaN(mean)) {
            throw new IllegalArgumentException("Data contains missing values");
        }
        double sum = 0.0;
        for (double v : this.data) {
            sum += v * v;
        }
        double meanSS = sum / (double)this.data.length;
        IntStream positiveLags = IntStream.rangeClosed(1, lags).parallel();
        DoubleStream positiveValues = meanSS > 0.0 ? positiveLags.mapToDouble(i -> AutoCorrelationFunction.meanSumOfSquaresAtLag(this.data, i) / meanSS) : positiveLags.mapToDouble(i -> 0.0);
        this.acf = DoubleStream.concat(DoubleStream.of(1.0), positiveValues).toArray();
    }

    public double[] acf() {
        return this.acf;
    }

    private static double meanSumOfSquaresAtLag(double[] data, int lag) {
        double num = 0.0;
        for (int i = lag; i < data.length; ++i) {
            num += data[i] * data[i - lag];
        }
        return num / (double)(data.length - lag);
    }
}

