/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting;

import com.ibm.bi.predict.algorithms.forecasting.ForecastingAlgorithmContext;
import com.ibm.bi.predict.algorithms.forecasting.models.ModelBuilder;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResult;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.graph.Tree;
import com.ibm.bi.predict.result.StatusCode;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ForecastingAlgorithm {
    private List<Tree<SeriesResult>> hierarchy;
    private ForecastingAlgorithmContext context;

    public ForecastingAlgorithm(List<Tree<SeriesResult>> hierarchy, ForecastingAlgorithmContext context) {
        this.hierarchy = hierarchy;
        this.context = context;
        this.prepareData(this.hierarchy);
    }

    public ForecastingResult run(Optional<Integer> forecastPeriods) {
        ModelBuilder modelBuilder = new ModelBuilder(this.context);
        Map<String, SeriesResult> result = modelBuilder.fit(this.hierarchy, forecastPeriods);
        return new ForecastingResult(StatusCode.SUCCESS, result, this.context.getTimeDimension());
    }

    private void prepareData(List<Tree<SeriesResult>> hierarchy) {
        for (Tree<SeriesResult> tree : hierarchy) {
            tree.walk(v -> ((SeriesResult)v.content()).handleMissingValues(), false);
        }
    }
}

