/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts;

import com.google.common.collect.ImmutableMap;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Tuple;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConceptDisambiguator {
    private static final Map<TimeConcept, TimeConcept> daysChildParentMap = ImmutableMap.of((Object)((Object)TimeConcept.DAY_OF_YEAR), (Object)((Object)TimeConcept.YEAR), (Object)((Object)TimeConcept.DAY_OF_MONTH), (Object)((Object)TimeConcept.MONTH), (Object)((Object)TimeConcept.DAY_OF_WEEK), (Object)((Object)TimeConcept.WEEK));

    private ConceptDisambiguator() {
    }

    public static boolean conceptsAreAmbiguous(List<Tuple<String, Double>> concepts, String parentConceptId) {
        List<TimeConcept> sameConfidenceConcepts = ConceptDisambiguator.conceptsWithMaxConfidence(concepts);
        return sameConfidenceConcepts.size() > 1 && daysChildParentMap.keySet().containsAll(sameConfidenceConcepts) && parentConceptId != null;
    }

    public static TimeConcept disambiguateConcepts(List<Tuple<String, Double>> concepts, String parentConceptId) {
        return ConceptDisambiguator.dayDisambiguator(concepts, parentConceptId);
    }

    private static TimeConcept dayDisambiguator(List<Tuple<String, Double>> concepts, String parentConceptId) {
        List<TimeConcept> sameConfidenceConcepts = ConceptDisambiguator.conceptsWithMaxConfidence(concepts);
        for (TimeConcept concept : sameConfidenceConcepts) {
            if (!daysChildParentMap.get((Object)concept).id().equals(parentConceptId)) continue;
            return concept;
        }
        return sameConfidenceConcepts.get(0);
    }

    private static List<TimeConcept> conceptsWithMaxConfidence(List<Tuple<String, Double>> concepts) {
        double maxConfidence = concepts.stream().filter(c -> TimeConcept.containsKey(c._1)).mapToDouble(c -> (Double)c._2).max().orElse(0.0);
        return concepts.stream().filter(c -> TimeConcept.containsKey(c._1)).filter(c -> NumericUtils.equals((double)maxConfidence, (double)((Double)c._2))).map(c -> TimeConcept.idToConcept((String)c._1)).collect(Collectors.toList());
    }
}

