/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts;

import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.types.Identifiable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public enum TimeConcept implements Identifiable
{
    UNKNOWN("", TimeUnit.UNKNOWN, false, 0, TimeUnit.UNKNOWN, true, 0, 0, false),
    DATE("http://www.ibm.com/ontologies/waca/domain/common#Date", TimeUnit.DAY, false, 0, TimeUnit.UNKNOWN, true, 0, 0, false),
    DATETIME("http://www.ibm.com/ontologies/waca/domain/common#DateTime", TimeUnit.SECOND, false, 0, TimeUnit.UNKNOWN, true, 0, 0, false),
    TIME("http://www.ibm.com/ontologies/waca/domain/common#Time", TimeUnit.SECOND, true, 86400, TimeUnit.DAY, true, 0, 0, false),
    YEAR_MONTH("http://www.ibm.com/ontologies/waca/domain/common#YearMonth", TimeUnit.MONTH, false, 0, TimeUnit.UNKNOWN, true, 0, 0, false),
    YEAR_QUARTER("http://www.ibm.com/ontologies/waca/domain/common#YearQuarter", TimeUnit.QUARTER, false, 0, TimeUnit.UNKNOWN, true, 0, 0, false),
    YEAR("http://www.ibm.com/ontologies/waca/domain/common#Year", TimeUnit.YEAR, false, 100, TimeUnit.CENTURY, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    QUARTER("http://www.ibm.com/ontologies/waca/domain/common#Quarter", TimeUnit.QUARTER, false, 4, TimeUnit.YEAR, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    MONTH("http://www.ibm.com/ontologies/waca/domain/common#Month", TimeUnit.MONTH, false, 12, TimeUnit.YEAR, false, 0, Integer.MAX_VALUE, true),
    WEEK("http://www.ibm.com/ontologies/waca/domain/common#Week", TimeUnit.WEEK, false, 53, TimeUnit.YEAR, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    DAY_OF_YEAR("http://www.ibm.com/ontologies/waca/domain/common#DayOfYear", TimeUnit.DAY, false, 366, TimeUnit.YEAR, false, 0, Integer.MAX_VALUE, false),
    DAY_OF_MONTH("http://www.ibm.com/ontologies/waca/domain/common#DayOfMonth", TimeUnit.DAY, false, 31, TimeUnit.MONTH, false, 0, Integer.MAX_VALUE, false),
    DAY_OF_WEEK("http://www.ibm.com/ontologies/waca/domain/common#DayOfWeek", TimeUnit.DAY, false, 7, TimeUnit.WEEK, false, 0, Integer.MAX_VALUE, true),
    HOUR("http://www.ibm.com/ontologies/waca/domain/common#Hour", TimeUnit.HOUR, true, 24, TimeUnit.DAY, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    MINUTE("http://www.ibm.com/ontologies/waca/domain/common#Minute", TimeUnit.MINUTE, true, 60, TimeUnit.HOUR, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    SECOND("http://www.ibm.com/ontologies/waca/domain/common#Second", TimeUnit.SECOND, true, 60, TimeUnit.MINUTE, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    SECOND_MINUTE("http://www.ibm.com/ontologies/waca/domain/common#SecondMinute", TimeUnit.SECOND, true, 60, TimeUnit.MINUTE, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    SEASON("http://www.ibm.com/ontologies/waca/domain/common#Season", TimeUnit.UNKNOWN, false, 0, TimeUnit.UNKNOWN, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false),
    PERIOD("http://www.ibm.com/ontologies/waca/domain/common#Period", TimeUnit.PERIOD, false, 0, TimeUnit.PERIOD, false, Integer.MIN_VALUE, Integer.MAX_VALUE, false);

    private final String conceptID;
    private final TimeUnit unit;
    private final TimeUnit parentTimeUnit;
    private final int cycleLength;
    private final boolean isZeroIndexed;
    private final boolean isTimestamp;
    private final Range cycleRange0;
    private final Range cycleRange1;
    private final Range indexRange;
    private final boolean hasStringRepr;
    private static Map<String, TimeConcept> CONCEPT_IDS;

    private TimeConcept(String conceptID, TimeUnit unit, boolean isZeroIndexed, int cycleLength, TimeUnit parentTimeUnit, boolean isTimestamp, int indexLowerBound, int indexUpperBound, boolean hasStringRepr) {
        this.conceptID = conceptID;
        this.cycleLength = cycleLength;
        this.isZeroIndexed = isZeroIndexed;
        this.unit = unit;
        this.parentTimeUnit = parentTimeUnit;
        this.isTimestamp = isTimestamp;
        this.hasStringRepr = hasStringRepr;
        this.cycleRange0 = new Range(0.0, (double)cycleLength);
        this.cycleRange1 = new Range(1.0, (double)cycleLength + 1.0);
        this.indexRange = new Range((double)indexLowerBound, (double)indexUpperBound);
    }

    public String id() {
        return this.conceptID;
    }

    public String toString() {
        return String.format("[conceptID: %s]", this.conceptID);
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean isZeroIndexed() {
        return this.isZeroIndexed;
    }

    public int getCycleLength() {
        return this.cycleLength;
    }

    public TimeUnit getParentTimeUnit() {
        return this.parentTimeUnit;
    }

    public Range getCycleRange0() {
        return this.cycleRange0;
    }

    public Range getCycleRange1() {
        return this.cycleRange1;
    }

    public Range getIndexRange() {
        return this.indexRange;
    }

    public boolean hasStringRepr() {
        return this.hasStringRepr;
    }

    public boolean isTimestamp() {
        return this.isTimestamp;
    }

    public boolean isNonTimestamp() {
        return !this.isTimestamp;
    }

    public static TimeConcept idToConcept(String conceptId) {
        return CONCEPT_IDS.get(conceptId);
    }

    public static boolean containsKey(Object key) {
        return CONCEPT_IDS.containsKey(key);
    }

    static {
        CONCEPT_IDS = new HashMap<String, TimeConcept>();
        CONCEPT_IDS.putAll(Arrays.stream(TimeConcept.values()).collect(Collectors.toMap(t -> t.id(), t -> t)));
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#TimeCyclical", TIME);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#PeriodCyclical", PERIOD);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#YearCyclical", YEAR);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#QuarterCyclical", QUARTER);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#MonthCyclical", MONTH);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#WeekCyclical", WEEK);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#DayOfYearCyclical", DAY_OF_YEAR);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#DayOfMonthCyclical", DAY_OF_MONTH);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#DayOfWeekCyclical", DAY_OF_WEEK);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#HourCyclical", HOUR);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#MinuteCyclical", MINUTE);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#SecondCyclical", SECOND);
        CONCEPT_IDS.put("http://www.ibm.com/ontologies/waca/application#SecondMinuteCyclical", SECOND_MINUTE);
    }
}

