/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts.validation;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimestampConceptMatch;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimestampConceptValidator {
    private static final TimestampConceptMatch FIXED_DATE_PATTERN = new TimestampConceptMatch("yyyy-MM-dd", TimeConcept.DATE);
    private static final TimestampConceptMatch DATE_PATTERN = new TimestampConceptMatch("y-M-d", TimeConcept.DATE);
    private static final TimestampConceptMatch FIXED_DATE_SLASH_PATTERN = new TimestampConceptMatch("MM/dd/yyyy", TimeConcept.DATE);
    private static final TimestampConceptMatch DATE_SLASH_PATTERN = new TimestampConceptMatch("M/d/y", TimeConcept.DATE);
    private static final TimestampConceptMatch FIXED_DATE_PATTERN_REVERSED = new TimestampConceptMatch("MM-dd-yyyy", TimeConcept.DATE);
    private static final TimestampConceptMatch FIXED_DATETIME_PATTERN_REVERSED = new TimestampConceptMatch("MM-dd-yyyy HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATETIME_SLASH_PATTERN_REVERSED = new TimestampConceptMatch("yyyy/MM/dd HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATE_SLASH_PATTERN_REVERSED = new TimestampConceptMatch("yyyy/MM/dd", TimeConcept.DATE);
    private static final TimestampConceptMatch FIXED_DATETIME_PATTERN = new TimestampConceptMatch("yyyy-MM-dd HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch DATETIME_PATTERN = new TimestampConceptMatch("y-M-d HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATETIME_PATTERN_T = new TimestampConceptMatch("yyyy-MM-dd'T'HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch DATETIME_PATTERN_T = new TimestampConceptMatch("y-M-d'T'H:m:s", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATETIME_SLASH_PATTERN = new TimestampConceptMatch("MM/dd/yyyy HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch DATETIME_SLASH_PATTERN = new TimestampConceptMatch("M/d/y HH:mm:ss", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATETIME_PATTERN_T_TZ = new TimestampConceptMatch("yyyy-MM-dd'T'HH:mm:ssXXX", TimeConcept.DATETIME);
    private static final TimestampConceptMatch DATETIME_PATTERN_T_TZ = new TimestampConceptMatch("y-M-d'T'H:m:sXXX", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATETIME_PATTERN_T_MS = new TimestampConceptMatch("yyyy-MM-dd'T'HH:mm:ss.SSS", TimeConcept.DATETIME);
    private static final TimestampConceptMatch DATETIME_PATTERN_T_MS = new TimestampConceptMatch("y-M-d'T'H:m:s.S", TimeConcept.DATETIME);
    private static final TimestampConceptMatch FIXED_DATETIME_PATTERN_T_MS_TZ = new TimestampConceptMatch("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", TimeConcept.DATETIME);
    private static final TimestampConceptMatch DATETIME_PATTERN_T_MS_TZ = new TimestampConceptMatch("y-M-d'T'H:m:s.SXXX", TimeConcept.DATETIME);
    private static final TimestampConceptMatch TIME_PATTERN = new TimestampConceptMatch("HH:mm:ss", TimeConcept.TIME);
    private static final TimestampConceptMatch TIME_PATTERN_MS = new TimestampConceptMatch("HH:mm:ss.SSS", TimeConcept.TIME);
    private static final TimestampConceptMatch FIXED_YEAR_MONTH_PATTERN = new TimestampConceptMatch("yyyy-MM", TimeConcept.YEAR_MONTH);
    private static final TimestampConceptMatch FIXED_YEAR_MONTH_PATTERN_REVERSED = new TimestampConceptMatch("MM-yyyy", TimeConcept.YEAR_MONTH);
    private static final TimestampConceptMatch YEAR_MONTH_PATTERN = new TimestampConceptMatch("y-M", TimeConcept.YEAR_MONTH);
    private static final TimestampConceptMatch FIXED_YEAR_MONTH_SLASH_PATTERN = new TimestampConceptMatch("MM/yyyy", TimeConcept.YEAR_MONTH);
    private static final TimestampConceptMatch YEAR_MONTH_SLASH_PATTERN = new TimestampConceptMatch("M/y", TimeConcept.YEAR_MONTH);
    private static final TimestampConceptMatch YEAR_QUARTER_PATTERN = new TimestampConceptMatch("y-'Q'Q", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch YEAR_QUARTER_SPACE_PATTERN = new TimestampConceptMatch("y 'Q'Q", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch QUARTER_YEAR_SPACE_PATTERN = new TimestampConceptMatch("'Q'Q y", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch QUARTER_YEAR_PATTERN = new TimestampConceptMatch("'Q'Q-y", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch LOWER_YEAR_QUARTER_PATTERN = new TimestampConceptMatch("y-'q'Q", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch LOWER_YEAR_QUARTER_SPACE_PATTERN = new TimestampConceptMatch("y 'q'Q", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch LOWER_QUARTER_YEAR_SPACE_PATTERN = new TimestampConceptMatch("'q'Q y", TimeConcept.YEAR_QUARTER);
    private static final TimestampConceptMatch LOWER_QUARTER_YEAR_PATTERN = new TimestampConceptMatch("'q'Q-y", TimeConcept.YEAR_QUARTER);
    private static final EnumMap<TimeConcept, List<TimestampConceptMatch>> TIMESTAMP_PATTERNS = new EnumMap(TimeConcept.class);

    private TimestampConceptValidator() {
    }

    public static TimestampConceptMatch match(TimeConcept concept, Set<String> fieldValues) {
        if (!concept.isTimestamp()) {
            throw new IllegalArgumentException("Non-timestamp concept " + (Object)((Object)concept) + " passed to TimestampConceptValidator");
        }
        List<TimestampConceptMatch> candidates = TIMESTAMP_PATTERNS.get((Object)concept);
        if (fieldValues.isEmpty()) {
            return TimestampConceptMatch.makeResult(candidates.get(0), Collections.emptySet());
        }
        candidates = TimestampConceptValidator.reorderCandidates(candidates, fieldValues);
        int numValues = fieldValues.size();
        TimestampConceptMatch bestMatch = null;
        Set<String> bestSet = null;
        int bestSize = numValues + 1;
        for (TimestampConceptMatch candidate : candidates) {
            Set<String> unmatched = TimestampConceptValidator.getUnmatchedValues(candidate.formatter, fieldValues, bestSize);
            int nbad = unmatched.size();
            if (nbad >= numValues || nbad >= bestSize) continue;
            bestMatch = candidate;
            bestSet = unmatched;
            bestSize = nbad;
            if (nbad != 0) continue;
            break;
        }
        if (bestMatch != null) {
            return TimestampConceptMatch.makeResult(bestMatch, bestSet);
        }
        throw new ForecastingParametersException("Could not find concept for " + concept.name() + " matching data values", ForecastingParametersExceptionKey.DATA_VALUE);
    }

    private static List<TimestampConceptMatch> reorderCandidates(List<TimestampConceptMatch> candidates, Set<String> fieldValues) {
        String value = fieldValues.iterator().next();
        ArrayList<TimestampConceptMatch> matched = new ArrayList<TimestampConceptMatch>();
        ArrayList<TimestampConceptMatch> unmatched = new ArrayList<TimestampConceptMatch>();
        for (TimestampConceptMatch c : candidates) {
            try {
                c.formatter.parse(value);
                matched.add(c);
            }
            catch (Exception e) {
                unmatched.add(c);
            }
        }
        matched.addAll(unmatched);
        return matched;
    }

    private static Set<String> getUnmatchedValues(DateTimeFormatter formatter, Set<String> fieldValues, int bestSize) {
        HashSet<String> unmatched = new HashSet<String>();
        for (String v : fieldValues) {
            try {
                formatter.parse(v);
            }
            catch (DateTimeParseException e) {
                unmatched.add(v);
                if (unmatched.size() < bestSize) continue;
                break;
            }
        }
        return unmatched;
    }

    static {
        TIMESTAMP_PATTERNS.put(TimeConcept.UNKNOWN, Arrays.asList(FIXED_DATE_PATTERN, FIXED_DATE_SLASH_PATTERN, FIXED_DATE_SLASH_PATTERN_REVERSED, FIXED_DATE_PATTERN_REVERSED, FIXED_DATETIME_PATTERN, FIXED_DATETIME_PATTERN_T, FIXED_DATETIME_PATTERN_T_TZ, FIXED_DATETIME_PATTERN_T_MS, FIXED_DATETIME_PATTERN_T_MS_TZ, FIXED_DATETIME_SLASH_PATTERN, FIXED_DATETIME_SLASH_PATTERN_REVERSED, FIXED_DATETIME_PATTERN_REVERSED, DATE_PATTERN, DATE_SLASH_PATTERN, DATETIME_PATTERN, DATETIME_PATTERN_T, DATETIME_PATTERN_T_TZ, DATETIME_PATTERN_T_MS, DATETIME_PATTERN_T_MS_TZ, DATETIME_SLASH_PATTERN, TIME_PATTERN, TIME_PATTERN_MS));
        TIMESTAMP_PATTERNS.put(TimeConcept.DATE, Arrays.asList(FIXED_DATE_PATTERN, FIXED_DATE_SLASH_PATTERN, FIXED_DATE_SLASH_PATTERN_REVERSED, FIXED_DATE_PATTERN_REVERSED, FIXED_DATETIME_PATTERN, FIXED_DATETIME_PATTERN_T, FIXED_DATETIME_PATTERN_T_TZ, FIXED_DATETIME_PATTERN_T_MS, FIXED_DATETIME_PATTERN_T_MS_TZ, FIXED_DATETIME_SLASH_PATTERN, FIXED_DATETIME_SLASH_PATTERN_REVERSED, FIXED_DATETIME_PATTERN_REVERSED, DATE_PATTERN, DATE_SLASH_PATTERN, DATETIME_PATTERN, DATETIME_PATTERN_T, DATETIME_PATTERN_T_TZ, DATETIME_PATTERN_T_MS, DATETIME_PATTERN_T_MS_TZ, DATETIME_SLASH_PATTERN, TIME_PATTERN, TIME_PATTERN_MS));
        TIMESTAMP_PATTERNS.put(TimeConcept.DATETIME, Arrays.asList(FIXED_DATETIME_PATTERN, FIXED_DATETIME_PATTERN_T, FIXED_DATETIME_PATTERN_T_TZ, FIXED_DATETIME_PATTERN_T_MS, FIXED_DATETIME_PATTERN_T_MS_TZ, FIXED_DATETIME_SLASH_PATTERN, FIXED_DATETIME_SLASH_PATTERN_REVERSED, FIXED_DATETIME_PATTERN_REVERSED, DATETIME_PATTERN, DATETIME_PATTERN_T, DATETIME_PATTERN_T_TZ, DATETIME_PATTERN_T_MS, DATETIME_PATTERN_T_MS_TZ, DATETIME_SLASH_PATTERN, FIXED_DATE_PATTERN, FIXED_DATE_SLASH_PATTERN, FIXED_DATE_PATTERN_REVERSED, FIXED_DATE_SLASH_PATTERN_REVERSED, DATE_PATTERN, DATE_SLASH_PATTERN));
        TIMESTAMP_PATTERNS.put(TimeConcept.TIME, Arrays.asList(TIME_PATTERN, TIME_PATTERN_MS));
        TIMESTAMP_PATTERNS.put(TimeConcept.YEAR_MONTH, Arrays.asList(FIXED_YEAR_MONTH_PATTERN, FIXED_YEAR_MONTH_SLASH_PATTERN, FIXED_YEAR_MONTH_PATTERN_REVERSED, YEAR_MONTH_PATTERN, YEAR_MONTH_SLASH_PATTERN));
        TIMESTAMP_PATTERNS.put(TimeConcept.YEAR_QUARTER, Arrays.asList(YEAR_QUARTER_PATTERN, YEAR_QUARTER_SPACE_PATTERN, QUARTER_YEAR_PATTERN, QUARTER_YEAR_SPACE_PATTERN, LOWER_YEAR_QUARTER_PATTERN, LOWER_YEAR_QUARTER_SPACE_PATTERN, LOWER_QUARTER_YEAR_PATTERN, LOWER_QUARTER_YEAR_SPACE_PATTERN));
    }
}

