/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.es.ESModelArrays;
import com.ibm.bi.predict.algorithms.forecasting.es.ESParameters;
import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.function.ToDoubleBiFunction;
import org.apache.commons.math3.distribution.TDistribution;

public class ESDiagnostics {
    private final int N;
    private final ESModelArrays model;
    private final ESMethod method;
    private final double sse;
    private final double mse;
    private final double mae;
    private final double maeNaive;
    private final double mape;
    private final int parameterPenaltyK;
    private final double[][] decomposition;
    private final Range range;

    ESDiagnostics(ESMethod method, ESModelArrays model, ESParameters parameters, double[] y, ToDoubleBiFunction<Integer, Integer> historicPredict) {
        this.N = y.length;
        this.model = model;
        this.method = method;
        double max = y.length == 0 ? Double.NaN : y[0];
        double min = y.length == 0 ? Double.NaN : y[0];
        double sseNaive = 0.0;
        double sae = 0.0;
        double saNaive = 0.0;
        double ape = 0.0;
        for (int i = 0; i < this.N; ++i) {
            double yhat = historicPredict.applyAsDouble(i, 1);
            double resid = y[i] - yhat;
            if (y[i] > max) {
                max = y[i];
            }
            if (y[i] < min) {
                min = y[i];
            }
            ape = y[i] != 0.0 ? (ape += Math.abs(resid / y[i])) : Double.NaN;
            sseNaive += resid * resid;
            sae += Math.abs(resid);
            if (i <= 0) continue;
            saNaive += Math.abs(y[i] - y[i - 1]);
        }
        this.range = Double.isNaN(min + max) ? null : new Range(min, max);
        this.sse = sseNaive;
        this.mse = this.sse / (double)(this.N - method.numberOfParameters());
        this.mae = sae / (double)this.N;
        this.maeNaive = saNaive / (double)(this.N - 1);
        this.mape = ape / (double)this.N;
        this.decomposition = new double[][]{y, null, null, null};
        this.parameterPenaltyK = 2 * method.numberOfParameters() + (parameters.m <= 1 ? 0 : parameters.m - 1) + (method.toString().startsWith("Ad") ? -1 : 0);
    }

    public int parameterPenaltyK() {
        return this.parameterPenaltyK;
    }

    public double AIC() {
        return (double)(2 * this.parameterPenaltyK) + (double)this.N * Math.log(this.sse / (double)this.N);
    }

    public double RMSE() {
        return Math.sqrt(this.mse);
    }

    public double MSE() {
        return this.mse;
    }

    public double MAE() {
        return this.mae;
    }

    public double MASE() {
        return this.mae / this.maeNaive;
    }

    public double accuracy() {
        if (NumericUtils.isZero((double)this.getMaeNaive())) {
            return this.accuracyForZeroMaeNaive();
        }
        return Math.max(0.0, 1.0 - this.MASE());
    }

    private double accuracyForZeroMaeNaive() {
        Range range = this.getRange();
        if (this.getMae() < (Math.abs(range.maxExclusive()) + Math.abs(range.minInclusive())) * 1.0E-9) {
            return 1.0;
        }
        return 0.0;
    }

    public double tValue(double confidence) {
        TDistribution tDist = new TDistribution((double)this.degreesOfFreedom());
        return tDist.inverseCumulativeProbability(1.0 - confidence / 2.0);
    }

    public int degreesOfFreedom() {
        return this.N - this.method.numberOfParameters();
    }

    public double[][] decomposition() {
        if (this.decomposition[1] == null) {
            this.decomposition[1] = new double[this.N];
            this.decomposition[2] = new double[this.N];
            this.decomposition[3] = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                this.decomposition[1][i] = this.model.l(i - 1);
                if (this.method.trend != ESMethod.Trend.NONE) {
                    double[] dArray = this.decomposition[1];
                    int n = i;
                    dArray[n] = dArray[n] + this.model.b(i - 1);
                }
                if (this.method.seasonality != ESMethod.Seasonality.NONE) {
                    this.decomposition[2][i] = this.model.s(i - this.model.getM());
                }
                this.decomposition[3][i] = this.decomposition[0][i] - this.decomposition[1][i] - this.decomposition[2][i];
            }
        }
        return this.decomposition;
    }

    private boolean isReasonableRange() {
        double ratio = this.range.maxExclusive() / this.range.minInclusive();
        return !(ratio > 1000000.0) && !(ratio < 1.0E-6);
    }

    public Double MAPE() {
        if (this.range.contains(0.0) || !this.isReasonableRange()) {
            return Double.NaN;
        }
        return this.mape;
    }

    public double getMaeNaive() {
        return this.maeNaive;
    }

    public double getMae() {
        return this.mae;
    }

    public Range getRange() {
        return this.range;
    }
}

