/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.es.ESDiagnostics;
import com.ibm.bi.predict.algorithms.forecasting.es.ESFunctions;
import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.es.ESModelArrays;
import com.ibm.bi.predict.algorithms.forecasting.es.ESParameters;
import com.ibm.bi.predict.algorithms.forecasting.util.KendallTauTrendAnalysis;
import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.exceptions.UnsuitableModelException;
import com.ibm.bi.predict.math.NumberFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ESFit {
    private final ESMethod method;
    private final ESParameters parameters;
    private ESDiagnostics diagnostics;
    private final double[] untransformed_y;
    private final double[] transformed_y;
    private Map<ESMethod, ESDiagnostics> fittedDiagnostics = Collections.emptyMap();
    private boolean optimizeError;
    private boolean hasrestrictedModels;
    private final ESModelArrays model;
    private List<Double> varianceFactors = new ArrayList<Double>();
    private KendallTauTrendAnalysis tauTrend;

    public ESFit(ESMethod method, ESParameters parameters, double[] y) throws UnsuitableModelException {
        this.method = method;
        this.parameters = parameters;
        this.untransformed_y = y;
        double[] dArray = this.transformed_y = method.usesLogTransform() ? ESFit.logTransform(y) : y;
        if (parameters == null) {
            this.model = null;
        } else {
            this.model = new ESModelArrays(method, parameters, this.transformed_y);
            this.build();
        }
    }

    protected ESFit(ESMethod method, ESParameters parameters, double[] y, double l0, double b0, double[] s0) throws UnsuitableModelException {
        this.method = method;
        this.parameters = parameters;
        this.untransformed_y = y;
        double[] dArray = this.transformed_y = method.usesLogTransform() ? ESFit.logTransform(y) : y;
        if (parameters == null) {
            this.model = null;
        } else {
            this.model = new ESModelArrays(method, parameters, this.transformed_y, l0, b0, s0);
            this.build();
        }
    }

    protected ESFit(ESMethod method, ESParameters parameters, double[] y, ESModelArrays model) {
        this.method = method;
        this.parameters = parameters;
        this.untransformed_y = y;
        this.transformed_y = method.usesLogTransform() ? ESFit.logTransform(y) : y;
        this.model = model;
        this.build();
    }

    public int rowCount() {
        return this.transformed_y.length;
    }

    public double AIC() {
        return this.diagnostics().AIC();
    }

    public void setOptimizeError() {
        this.optimizeError = true;
    }

    public boolean getOptimizeError() {
        return this.optimizeError;
    }

    public ESDiagnostics diagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new ESDiagnostics(this.method, this.model, this.parameters, this.transformed_y, this::transformedHistorical);
        }
        return this.diagnostics;
    }

    public double forecast(int i) {
        double forecastedValue = this.method.forecastFunction.forecast(this.parameters, this.model, this.transformed_y.length - 1, i);
        if (this.method.usesLogTransform()) {
            forecastedValue = Math.exp(forecastedValue);
        }
        return forecastedValue;
    }

    public Range forecastConfidence(int i, double level) {
        double forecast = this.forecast(i);
        return this.getConfidenceRangeForEstimate(forecast, i, level, this.transformed_y.length - 1);
    }

    public Range historyConfidence(int i, double level) {
        double estimate = this.historical(i, 1);
        return this.getConfidenceRangeForEstimate(estimate, 1, level, i - 1);
    }

    public double[] fittedValues() {
        double[] fitted = new double[this.untransformed_y.length];
        for (int i = 0; i < this.untransformed_y.length; ++i) {
            fitted[i] = this.historical(i, 1);
        }
        return fitted;
    }

    public List<Double> varianceFactors() {
        return this.varianceFactors;
    }

    private Range getConfidenceRangeForEstimate(double estimate, int i, double level, int t) {
        double varianceFactor = this.method.varianceFactorFunction.varianceFactor(this.parameters, this.model, t, i);
        this.varianceFactors.add(varianceFactor);
        double tVal = this.diagnostics().tValue(1.0 - level);
        double ci = tVal * Math.sqrt(this.diagnostics().MSE() * varianceFactor);
        if (this.method.usesLogTransform()) {
            double upperLimit = Math.exp(Math.log(estimate) + ci);
            double lowerLimit = Math.exp(Math.log(estimate) - ci);
            return new Range(lowerLimit, upperLimit);
        }
        return new Range(estimate - ci, estimate + ci);
    }

    public double historical(int t, int lag) {
        double v = this.transformedHistorical(t, lag);
        return this.method.usesLogTransform() ? Math.exp(v) : v;
    }

    double transformedHistorical(int t, int lag) {
        return this.method.forecastFunction.forecast(this.parameters, this.model, t - lag, lag);
    }

    public ESMethod method() {
        return this.method;
    }

    public String name() {
        return this.method.hasSeasonality() ? this.method + "(" + this.period() + ")" : this.method.toString();
    }

    public ESParameters parameters() {
        return this.parameters;
    }

    public int period() {
        return this.parameters.m;
    }

    public ESModelArrays getModel() {
        return this.model;
    }

    public String toString() {
        return "ES(" + this.method + ": " + this.parameters.listParameters() + " \u2192 " + NumberFormatter.format((Locale)Locale.US, (boolean)false, (double)this.accuracy()) + ")";
    }

    public double accuracy() {
        return this.diagnostics().accuracy();
    }

    public double transformedY(int i) {
        return this.transformed_y[i];
    }

    public double y(int i) {
        return this.untransformed_y[i];
    }

    double[] getY() {
        return this.untransformed_y;
    }

    public TrendDirection getTrendDirection() {
        if (this.tauTrend == null) {
            this.tauTrend = new KendallTauTrendAnalysis(this);
        }
        if (this.tauTrend.getTau() < 0.0 && this.tauTrend.getP() < 0.05) {
            return TrendDirection.DOWNWARD;
        }
        if (this.tauTrend.getTau() > 0.0 && this.tauTrend.getP() < 0.05) {
            return TrendDirection.UPWARD;
        }
        return TrendDirection.NONE;
    }

    public TrendStrength getTrendStrength() {
        double tauMag;
        if (this.tauTrend == null) {
            this.tauTrend = new KendallTauTrendAnalysis(this);
        }
        if ((tauMag = Math.abs(this.tauTrend.getTau())) > 0.8) {
            return TrendStrength.STRONG;
        }
        if (tauMag > 0.5) {
            return TrendStrength.MODERATE;
        }
        if (tauMag > 0.2) {
            return TrendStrength.WEAK;
        }
        return TrendStrength.NONE;
    }

    private void build() {
        ESFunctions.UpdateFn updateFunction = this.method.updateFunction;
        for (int t = 0; t < this.transformed_y.length; ++t) {
            updateFunction.update(this.parameters, this.model, this.transformed_y, t);
        }
    }

    private static double[] logTransform(double[] y) {
        double[] logY = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            logY[i] = Math.log(y[i]);
        }
        return logY;
    }

    public Map<ESMethod, ESDiagnostics> getFittedDiagnostics() {
        return this.fittedDiagnostics;
    }

    protected void setTauTrend(KendallTauTrendAnalysis tauTrend) {
        this.tauTrend = tauTrend;
    }

    public ESFit setFittedDiagnostics(Map<ESMethod, ESDiagnostics> fittedDiagnostics) {
        this.fittedDiagnostics = fittedDiagnostics;
        return this;
    }

    public void putFittedDiagnostics(ESMethod method, ESDiagnostics diagnostics) {
        this.fittedDiagnostics.put(method, diagnostics);
    }

    public void setRestrictedModels(boolean hasrestrictedModels) {
        this.hasrestrictedModels = hasrestrictedModels;
    }

    public boolean hasRestrictedModels() {
        return this.hasrestrictedModels;
    }

    public static enum TrendStrength {
        STRONG,
        MODERATE,
        WEAK,
        NONE;

    }

    public static enum TrendDirection {
        UPWARD,
        DOWNWARD,
        NONE;

    }
}

