/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.es.ESModelArrays;
import com.ibm.bi.predict.algorithms.forecasting.es.ESParameters;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;

public class ESFunctions {
    static double AA_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        int k = (h - 1) / p.m;
        return S.l(t) + (double)h * S.b(t) + S.s(t + h - p.m * (k + 1));
    }

    static void AA_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * (y[t] - S.s(t - p.m)) + (1.0 - p.alpha) * (S.l(t - 1) + S.b(t - 1)));
        S.setB(t, p.beta * (S.l(t) - S.l(t - 1)) + (1.0 - p.beta) * S.b(t - 1));
        S.setS(t, p.gamma * (y[t] - S.l(t)) + (1.0 - p.gamma) * S.s(t - p.m));
    }

    static double AA_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.additiveConfidence(p.m, h, i -> p.alpha + i * p.alpha * p.beta, p.gamma * (1.0 - p.alpha));
    }

    static double AM_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        int k = (h - 1) / p.m;
        return (S.l(t) + (double)h * S.b(t)) * S.s(t + h - p.m * (k + 1));
    }

    static void AM_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * (y[t] / S.s(t - p.m)) + (1.0 - p.alpha) * (S.l(t - 1) + S.b(t - 1)));
        S.setB(t, p.beta * (S.l(t) - S.l(t - 1)) + (1.0 - p.beta) * S.b(t - 1));
        S.setS(t, p.gamma * y[t] / S.l(t) + (1.0 - p.gamma) * S.s(t - p.m));
    }

    static double AM_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.multiplicativeConfidence(p.m, h, t, m, i -> p.alpha + p.alpha * (double)i * p.beta, p.gamma * (1.0 - p.alpha));
    }

    static double AN_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        return S.l(t) + (double)h * S.b(t);
    }

    static void AN_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * y[t] + (1.0 - p.alpha) * (S.l(t - 1) + S.b(t - 1)));
        S.setB(t, p.beta * (S.l(t) - S.l(t - 1)) + (1.0 - p.beta) * S.b(t - 1));
    }

    static double AN_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.noneConfidence(h, i -> p.alpha + i * p.alpha * p.beta);
    }

    static double AdA_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        int k = (h - 1) / p.m;
        double phi_h = ESFunctions.sumPowers(p.phi, h);
        return S.l(t) + phi_h * S.b(t) + S.s(t + h - p.m * (k + 1));
    }

    static void AdA_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * (y[t] - S.s(t - p.m)) + (1.0 - p.alpha) * (S.l(t - 1) + p.phi * S.b(t - 1)));
        S.setB(t, p.beta * (S.l(t) - S.l(t - 1)) + (1.0 - p.beta) * p.phi * S.b(t - 1));
        S.setS(t, p.gamma * (y[t] - S.l(t)) + (1.0 - p.gamma) * S.s(t - p.m));
    }

    static double AdA_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.additiveConfidence(p.m, h, i -> p.alpha + p.alpha * p.beta * p.phi * (Math.pow(p.phi, i) - 1.0) / (p.phi - 1.0), p.gamma * (1.0 - p.alpha));
    }

    static double AdM_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        int k = (h - 1) / p.m;
        double phi_h = ESFunctions.sumPowers(p.phi, h);
        return (S.l(t) + phi_h * S.b(t)) * S.s(t + h - p.m * (k + 1));
    }

    static double AdM_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.multiplicativeConfidence(p.m, h, t, m, i -> p.alpha + p.alpha * p.beta * p.phi * (Math.pow(p.phi, i) - 1.0) / (p.phi - 1.0), p.gamma * (1.0 - p.alpha));
    }

    static void AdM_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * (y[t] / S.s(t - p.m)) + (1.0 - p.alpha) * (S.l(t - 1) + p.phi * S.b(t - 1)));
        S.setB(t, p.beta * (S.l(t) - S.l(t - 1)) + (1.0 - p.beta) * p.phi * S.b(t - 1));
        S.setS(t, p.gamma * y[t] / S.l(t) + (1.0 - p.gamma) * S.s(t - p.m));
    }

    static double AdN_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        double phi_h = ESFunctions.sumPowers(p.phi, h);
        return S.l(t) + phi_h * S.b(t);
    }

    static void AdN_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * y[t] + (1.0 - p.alpha) * (S.l(t - 1) + p.phi * S.b(t - 1)));
        S.setB(t, p.beta * (S.l(t) - S.l(t - 1)) + (1.0 - p.beta) * p.phi * S.b(t - 1));
    }

    static double AdN_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.noneConfidence(h, i -> p.alpha + p.alpha * p.beta * p.phi * (Math.pow(p.phi, i) - 1.0) / (p.phi - 1.0));
    }

    static double NA_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        int k = (h - 1) / p.m;
        return S.l(t) + S.s(t + h - p.m * (k + 1));
    }

    static void NA_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * (y[t] - S.s(t - p.m)) + (1.0 - p.alpha) * S.l(t - 1));
        S.setS(t, p.gamma * (y[t] - S.l(t)) + (1.0 - p.gamma) * S.s(t - p.m));
    }

    static double NA_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.additiveConfidence(p.m, h, i -> p.alpha, p.gamma * (1.0 - p.alpha));
    }

    static double NM_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        int k = (h - 1) / p.m;
        return S.l(t) * S.s(t + h - p.m * (k + 1));
    }

    static void NM_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * (y[t] / S.s(t - p.m)) + (1.0 - p.alpha) * S.l(t - 1));
        S.setS(t, p.gamma * (y[t] / S.l(t)) + (1.0 - p.gamma) * S.s(t - p.m));
    }

    static double NM_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return ESFunctions.multiplicativeConfidence(p.m, h, t, m, i -> p.alpha, p.gamma * (1.0 - p.alpha));
    }

    static double NN_forecast(ESParameters p, ESModelArrays S, int t, int h) {
        return S.l(t);
    }

    static void NN_update(ESParameters p, ESModelArrays S, double[] y, int t) {
        S.setL(t, p.alpha * y[t] + (1.0 - p.alpha) * S.l(t - 1));
    }

    static double NN_varianceFactor(ESParameters p, ESModelArrays m, int t, int h) {
        return 1.0 + (double)(h - 1) * p.alpha * p.alpha;
    }

    private static double noneConfidence(int h, DoubleUnaryOperator base) {
        double total = 1.0;
        for (int i = 1; i < h; ++i) {
            double val = base.applyAsDouble(i);
            total += val * val;
        }
        return total;
    }

    private static double additiveConfidence(int m, int h, DoubleUnaryOperator base, double seasonal) {
        double total = 1.0;
        for (int i = 1; i < h; ++i) {
            double psi = base.applyAsDouble(i);
            if (i % m == 0) {
                psi += seasonal;
            }
            total += psi * psi;
        }
        return total;
    }

    private static double multiplicativeConfidence(int m, int h, int t, ESModelArrays M, IntFunction<Double> base, double seasonal) {
        double total = 1.0;
        int count = 0;
        int sLength = M.arraysLength();
        int i = 0;
        while (count < h) {
            for (int j = 0; j < m; ++j) {
                int index2;
                double psi = ESFunctions.multiplicativePsi(j + i * m, h, m, base, seasonal);
                int index1 = t + h;
                if (index1 >= sLength) {
                    int diff = index1 - sLength;
                    index1 -= m * (1 + diff / m);
                }
                if ((index2 = t + h - j) >= sLength) {
                    int diff = index2 - sLength;
                    index2 -= m * (1 + diff / m);
                }
                double val = psi * M.s(index1) / M.s(index2);
                total += val * val;
                ++count;
            }
            ++i;
        }
        return total;
    }

    private static double multiplicativePsi(int j, int k, int m, IntFunction<Double> base, double seasonal) {
        if (j == 0) {
            return 0.0;
        }
        if (j >= k) {
            return 0.0;
        }
        double psi = base.apply(j);
        if (j % m == 0) {
            psi += seasonal;
        }
        return psi;
    }

    private static double sumPowers(double x, int n) {
        double p = x;
        double sum = x;
        for (int i = 2; i <= n; ++i) {
            sum += (p *= x);
        }
        return sum;
    }

    @FunctionalInterface
    public static interface UpdateFn {
        public void update(ESParameters var1, ESModelArrays var2, double[] var3, int var4);
    }

    @FunctionalInterface
    public static interface ForecastFn {
        public double forecast(ESParameters var1, ESModelArrays var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface VarianceFactorFn {
        public double varianceFactor(ESParameters var1, ESModelArrays var2, int var3, int var4);
    }
}

