/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.es.ESParameters;
import com.ibm.bi.predict.exceptions.UnsuitableModelException;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.Arrays;

public class ESModelArrays {
    private final double[] l;
    private final double[] b;
    private final double[] s;
    private final int m;
    private double l0;
    private double b0;
    private double[] s0;

    public ESModelArrays(double l0, double b0, double[] s0, int length) {
        this.l0 = l0;
        this.b0 = b0;
        this.l = new double[length];
        this.b = new double[length];
        this.s0 = s0;
        this.m = s0 == null ? 0 : s0.length;
        this.s = s0 == null ? null : new double[length];
    }

    public ESModelArrays(ESMethod method, ESParameters parameters, double[] y, double l0, double b0, double[] s0) throws UnsuitableModelException {
        this.l0 = l0;
        this.b0 = b0;
        this.s0 = s0;
        this.checkValidParameters(method, parameters, y);
        this.m = parameters.m;
        this.l = new double[y.length];
        this.s = method.hasSeasonality() ? new double[y.length] : null;
        this.b = method.hasTrend() ? new double[y.length] : null;
    }

    public ESModelArrays(ESMethod method, ESParameters parameters, double[] y) throws UnsuitableModelException {
        int initialPeriod;
        double[] deSeasonedValues;
        boolean isAdditive;
        this.checkValidParameters(method, parameters, y);
        this.m = parameters.m;
        this.l = new double[y.length];
        this.s = method.hasSeasonality() ? new double[y.length] : null;
        this.b = method.hasTrend() ? new double[y.length] : null;
        boolean bl = isAdditive = method.seasonality == ESMethod.Seasonality.ADDITIVE;
        if (method.hasSeasonality()) {
            double[] v;
            if (method.hasTrend()) {
                int lower = this.m / 2;
                int window = y.length < 3 * this.m ? this.m : 2 * this.m;
                v = this.removeTrendFromModelWithTrend(y, this.m, method, lower, window);
                this.s0 = this.initialSeasonalityForDetrendedDataWithTrend(v, isAdditive, lower, window);
            } else {
                v = this.removeTrendFromModelWithoutTrend(y, this.m, method);
                this.s0 = this.initialSeasonalityForDetrendedDataWithoutTrend(v, isAdditive);
            }
            this.removeSeasonality(v, y, this.s0, isAdditive);
            deSeasonedValues = v;
        } else {
            this.s0 = null;
            deSeasonedValues = y;
        }
        int n = initialPeriod = method.hasSeasonality() ? 2 * this.m : Math.max(5, Math.min(y.length / 10, 200));
        if (method.hasTrend()) {
            double[] params = NumericUtils.simpleLinearRegression((double[])deSeasonedValues, (int)initialPeriod);
            this.b0 = params[1];
            this.l0 = params[0] - this.b0;
        } else {
            int initialPeriodAdjusted = method.hasSeasonality() ? 2 * this.m : Math.min(50, y.length);
            this.l0 = NumericUtils.mean((double[])y, (int)initialPeriodAdjusted);
            this.b0 = Double.NaN;
        }
    }

    private void checkValidParameters(ESMethod method, ESParameters parameters, double[] y) throws UnsuitableModelException {
        if (!ESModelArrays.validPeriod(parameters.m, y.length)) {
            String message = String.format("Insufficient data for period %d (data is of length %d)", parameters.m, y.length);
            throw new UnsuitableModelException((Object)method, message);
        }
    }

    private void removeSeasonality(double[] result, double[] y, double[] seasonality, boolean additiveSeasonality) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = additiveSeasonality ? y[i] - seasonality[i % this.m] : y[i] / seasonality[i % this.m];
        }
    }

    private double[] initialSeasonalityForDetrendedDataWithoutTrend(double[] v, boolean additiveSeasonality) {
        double[] vt;
        block4: {
            int i;
            double mean;
            block3: {
                vt = new double[this.m];
                mean = 0.0;
                for (i = 0; i < this.m; ++i) {
                    vt[i] = (v[i] + v[i + this.m]) / 2.0;
                    mean += vt[i];
                }
                mean /= (double)this.m;
                if (!additiveSeasonality) break block3;
                i = 0;
                while (i < this.m) {
                    int n = i++;
                    vt[n] = vt[n] - mean;
                }
                break block4;
            }
            if (mean == 0.0) break block4;
            i = 0;
            while (i < this.m) {
                int n = i++;
                vt[n] = vt[n] / mean;
            }
        }
        return vt;
    }

    private double[] initialSeasonalityForDetrendedDataWithTrend(double[] v, boolean additiveSeasonality, int lower, int window) {
        int i;
        double[] vt = new double[2 * this.m];
        double mean = 0.0;
        for (i = lower; i < lower + this.m; ++i) {
            vt[i] = window == 2 * this.m ? (v[i] + v[i + this.m]) / 2.0 : v[i];
            mean += vt[i];
        }
        if (this.m != 0) {
            mean /= (double)this.m;
        }
        for (i = 0; i < this.m; ++i) {
            if (i < lower) {
                vt[i] = vt[i + this.m];
            }
            if (additiveSeasonality) {
                int n = i;
                vt[n] = vt[n] - mean;
                continue;
            }
            if (mean == 0.0) continue;
            int n = i;
            vt[n] = vt[n] / mean;
        }
        return Arrays.copyOfRange(vt, 0, this.m);
    }

    public final void setL(int t, double v) {
        this.l[t] = v;
    }

    public final void setB(int t, double v) {
        this.b[t] = v;
    }

    public final void setS(int t, double v) {
        this.s[t] = v;
    }

    private double[] removeTrendFromModelWithoutTrend(double[] y, int m, ESMethod method) {
        double[] v = ESModelArrays.meanValues(y, 2 * m);
        for (int i = 0; i < v.length; ++i) {
            if (method.seasonality == ESMethod.Seasonality.ADDITIVE) {
                v[i] = y[i] - v[i];
                continue;
            }
            if (v[i] == 0.0) continue;
            v[i] = y[i] / v[i];
        }
        return v;
    }

    private double[] removeTrendFromModelWithTrend(double[] y, int m, ESMethod method, int lower, int window) {
        double[] v = NumericUtils.movingAverageSmoothAdjusted((double[])y, (int)m, (int)lower, (int)window);
        for (int i = lower; i < lower + window; ++i) {
            if (method.seasonality == ESMethod.Seasonality.ADDITIVE) {
                v[i] = y[i] - v[i];
                continue;
            }
            if (v[i] == 0.0) continue;
            v[i] = y[i] / v[i];
        }
        return v;
    }

    public double[] getMeanSeasonalValues() {
        double[] meanS = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            double sum = 0.0;
            int count = 0;
            for (int j = i; j < this.s.length; j += this.m) {
                sum += this.s(j - this.m);
                ++count;
            }
            meanS[i] = count == 0 ? 0.0 : sum / (double)count;
        }
        return meanS;
    }

    public boolean isValidSeasonalMax(int candidate, double threshold) {
        if (candidate < 0 || candidate > this.m - 1) {
            return false;
        }
        int periodCount = 0;
        double[] topCount = new double[this.m];
        int argMax = NumericUtils.argmax((double[])this.s0);
        if (NumericUtils.isUnique((int)argMax, (double[])this.s0)) {
            int n = NumericUtils.argmax((double[])this.s0);
            topCount[n] = topCount[n] + 1.0;
            ++periodCount;
        }
        for (int i = this.m; i <= this.s.length - this.m; i += this.m) {
            double[] subS = Arrays.copyOfRange(this.s, i - this.m, i);
            argMax = NumericUtils.argmax((double[])subS);
            if (!NumericUtils.isUnique((int)argMax, (double[])subS)) continue;
            int n = argMax;
            topCount[n] = topCount[n] + 1.0;
            ++periodCount;
        }
        return periodCount != 0 && topCount[candidate] / (double)periodCount > threshold;
    }

    public boolean isValidSeasonalMin(int candidate, double threshold) {
        if (candidate < 0 || candidate > this.m - 1) {
            return false;
        }
        int periodCount = 0;
        double[] topCount = new double[this.m];
        int argMin = NumericUtils.argmin((double[])this.s0);
        if (NumericUtils.isUnique((int)argMin, (double[])this.s0)) {
            int n = argMin;
            topCount[n] = topCount[n] + 1.0;
            ++periodCount;
        }
        for (int i = this.m; i <= this.s.length - this.m; i += this.m) {
            double[] subS = Arrays.copyOfRange(this.s, i - this.m, i);
            argMin = NumericUtils.argmin((double[])subS);
            if (!NumericUtils.isUnique((int)argMin, (double[])subS)) continue;
            int n = argMin;
            topCount[n] = topCount[n] + 1.0;
            ++periodCount;
        }
        return periodCount != 0 && topCount[candidate] / (double)periodCount > threshold;
    }

    private static double[] meanValues(double[] v, int n) {
        double[] result = new double[n];
        Arrays.fill(result, NumericUtils.mean((double[])v, (int)n));
        return result;
    }

    public final double l(int i) {
        return i == -1 ? this.l0 : this.l[i];
    }

    public final double b(int i) {
        return i == -1 ? this.b0 : this.b[i];
    }

    public final double s(int i) {
        return i < 0 ? this.s0[i + this.m] : this.s[i];
    }

    public int getM() {
        return this.m;
    }

    public int arraysLength() {
        return this.s.length;
    }

    public void setL0(double l0) {
        this.l0 = l0;
    }

    public void setB0(double b0) {
        this.b0 = b0;
    }

    public void setS0(double[] s0) {
        this.s0 = s0;
    }

    public double[] getL() {
        return this.l;
    }

    public double[] getB() {
        return this.b;
    }

    public double[] getS() {
        return this.s;
    }

    public double getInitialLevel() {
        return this.l0;
    }

    public double getInitialSlope() {
        return this.b0;
    }

    public double[] getInitialSeasonalStates() {
        if (this.s0 != null) {
            return (double[])this.s0.clone();
        }
        return new double[0];
    }

    public static boolean validPeriod(int period, int numDataPoints) {
        return period <= 1 || numDataPoints >= Math.max(2 * period, period + 5);
    }
}

