/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.hierarchy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Hierarchy {
    private final String name;
    private final int[] columns;
    private final Map<String, List<String>> childMap;

    public Hierarchy(String name, int[] columns, Map<String, List<String>> childMap) {
        if (name == null || columns == null || childMap == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.columns = columns;
        this.childMap = childMap;
    }

    public Hierarchy(String name, int[] columns) {
        this(name, columns, new HashMap<String, List<String>>());
    }

    public String getName() {
        return this.name;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public Map<String, List<String>> getChildMap() {
        return this.childMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hierarchy)) {
            return false;
        }
        Hierarchy h = (Hierarchy)o;
        return this.name.equals(h.getName()) && Arrays.equals(this.columns, h.getColumns()) && this.childMap.equals(h.getChildMap());
    }

    public int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.columns), this.childMap);
    }
}

