/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.labels;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.labels.CyclicalTextLabels;
import com.ibm.bi.predict.algorithms.forecasting.labels.LabelUtils;
import com.ibm.bi.predict.algorithms.forecasting.labels.TimeLabel;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeLimits;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.util.EndOfMonthUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CyclicalIndexLabels
implements TimeLabel {
    private static final Logger LOG = PredictLoggerFactory.getLogger(CyclicalIndexLabels.class);
    protected final Locale locale;
    protected final Locale defaultLocale;
    protected final NumberFormat numberFormat;
    protected final NumberFormat defaultNumberFormat;
    protected final TimeConcept concept;
    protected List<String> categoricalNonNumericalIndexList;
    protected boolean treatAsIndexing = false;
    protected TimeDimension timeDimension;
    protected int conceptIndex;
    protected TimeDelta distance;

    public CyclicalIndexLabels(Locale locale, TimeDimension timeDimension, int conceptIndex) {
        this.locale = locale;
        this.defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
        ThreadLocal<DecimalFormat> formatter = this.getFormatter(locale);
        this.numberFormat = formatter.get();
        ThreadLocal<DecimalFormat> defaultFormatter = this.getFormatter(this.defaultLocale);
        this.defaultNumberFormat = defaultFormatter.get();
        this.timeDimension = timeDimension;
        this.conceptIndex = conceptIndex;
        this.concept = timeDimension.concept(conceptIndex);
        this.distance = timeDimension.getTimeDelta();
        this.categoricalNonNumericalIndexList = new ArrayList<String>();
    }

    public ThreadLocal<DecimalFormat> getFormatter(final Locale locale) {
        return new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("#", new DecimalFormatSymbols(locale));
            }
        };
    }

    protected int getIndexSize() {
        if (!this.categoricalNonNumericalIndexList.isEmpty()) {
            return this.categoricalNonNumericalIndexList.size();
        }
        return this.concept.getCycleLength();
    }

    protected Logger getLogger() {
        return LOG;
    }

    public List<String> getIndexList(int startingIndex, NumberFormat numberFormat) {
        ArrayList<String> indexList = new ArrayList<String>();
        for (int i = startingIndex; i <= startingIndex + this.getIndexSize() - 1; ++i) {
            indexList.add(numberFormat.format(i));
        }
        return indexList;
    }

    @Override
    public List<Tuple<String, TimeDelta>> getNextNLabels(int forecastOffset, int numberOfLabels, List<TimeDelta> carryOverList) {
        ArrayList<Tuple<String, TimeDelta>> labelList = new ArrayList<Tuple<String, TimeDelta>>();
        boolean skipGenerationCase = false;
        if (this.distance.getUnit() != this.concept.getUnit() && carryOverList.get(0).getUnit() != this.concept.getUnit()) {
            skipGenerationCase = true;
        }
        int[] rowOrder = this.timeDimension.getRowOrder();
        int initialLabelIndex = rowOrder[0];
        String[] labels = this.timeDimension.getDateLabels(initialLabelIndex);
        String initialLabel = labels[this.conceptIndex];
        if (!this.timeDimension.isComponentNumeric(this.conceptIndex) || this.timeDimension.concept(this.conceptIndex) == TimeConcept.PERIOD) {
            this.categoricalNonNumericalIndexList = this.timeDimension.getValidConceptCategories(this.conceptIndex);
        }
        int offset = this.timeDimension.getNumberOfTimePointsConsidered() - forecastOffset;
        TimeUnit parentTimeUnit = this.getParentTimeUnit(this.timeDimension, this.conceptIndex);
        TimeDelta carryOverForThisConcept = new TimeDelta(0L, parentTimeUnit);
        TimeDelta carryOverToNotConsiderForPostProcessing = new TimeDelta(0L, parentTimeUnit);
        boolean hasVariableLimits = ConceptUtils.hasVariableLimits(this.concept, this.conceptIndex);
        for (int i = 0; i < numberOfLabels; ++i) {
            Tuple<String, TimeDelta> nextLabel = null;
            nextLabel = skipGenerationCase ? Tuple.of((Object)initialLabel, (Object)new TimeDelta(0L, this.concept.getUnit())) : (hasVariableLimits ? this.handleLabelWithVariableLimits(carryOverList.get(i), carryOverForThisConcept, labels, initialLabel, offset, i) : this.handleLabelWithFixedLimits(carryOverList.get(i), initialLabel, offset, parentTimeUnit));
            carryOverForThisConcept = carryOverForThisConcept.add((TimeDelta)nextLabel._2);
            initialLabel = (String)nextLabel._1;
            offset = 1;
            int numberOfLabelsReused = this.timeDimension.getLastNPointsIgnored();
            if (i < numberOfLabelsReused) {
                carryOverToNotConsiderForPostProcessing = carryOverToNotConsiderForPostProcessing.add((TimeDelta)nextLabel._2);
            }
            String label = i < numberOfLabelsReused ? (String)nextLabel._1 : this.postProcessLabel(nextLabel, carryOverForThisConcept, carryOverToNotConsiderForPostProcessing, i);
            labelList.add((Tuple<String, TimeDelta>)Tuple.of((Object)label, (Object)nextLabel._2));
        }
        return labelList;
    }

    private TimeUnit getParentTimeUnit(TimeDimension timeDimension, int conceptIndex) {
        if (ConceptUtils.isQuarterMonthConcepts(timeDimension, conceptIndex)) {
            return TimeUnit.QUARTER;
        }
        return this.concept.getParentTimeUnit();
    }

    private boolean isEndOfMonthCase(TimeDimension timeDimension, int conceptIndex, TimeDelta delta) {
        if (EndOfMonthUtils.hasMonthAndDayAsHighestConcepts(timeDimension) && conceptIndex == 1 && delta.getUnit() == TimeUnit.MONTH) {
            int[] rowOrder = timeDimension.getRowOrder();
            for (int i = 0; i < rowOrder.length; ++i) {
                String[] labels = timeDimension.getDateLabels(rowOrder[i]);
                if (Integer.parseInt(labels[1]) == EndOfMonthUtils.getDaysInMonth(i, timeDimension)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Tuple<String, TimeDelta> handleLabelWithVariableLimits(TimeDelta carryOverFromChildConcept, TimeDelta carryOverForThisConcept, String[] labels, String initialLabel, int offset, int i) {
        TimeDelta distance = this.timeDimension.getTimeDelta();
        if (this.isEndOfMonthCase(this.timeDimension, this.conceptIndex, distance)) {
            offset = this.timeDimension.getNumberOfTimePointsConsidered();
            return LabelUtils.getEndOfMonthLabel(distance, this.timeDimension.isComponentZeroIndexed(this.conceptIndex - 1), offset, i, labels, this.numberFormat, this.defaultNumberFormat);
        }
        int indexSize = this.getIndexSize();
        boolean isZeroIndexed = this.timeDimension.isComponentZeroIndexed(this.conceptIndex);
        Tuple<String, TimeDelta> nextLabel = Tuple.of((Object)"", (Object)new TimeDelta(0L, this.concept.getParentTimeUnit()));
        TimeDelta cumulativeCarryOverForThisLabel = new TimeDelta(0L, this.concept.getParentTimeUnit());
        for (int j = 0; j < offset; ++j) {
            TimeDelta delta = new TimeDelta(0L, this.concept.getUnit());
            if (j == 0) {
                delta = carryOverFromChildConcept.add(distance);
            } else if (distance.getUnit() == this.concept.getUnit()) {
                delta = distance;
            }
            TimeDelta deltaForLimit = carryOverForThisConcept.add(cumulativeCarryOverForThisLabel);
            int limit = TimeLimits.getLimit(this.conceptIndex, deltaForLimit, this.timeDimension, 0);
            if (limit > 0) {
                indexSize = limit;
            }
            nextLabel = this.getNextLabel(initialLabel, delta.getSteps(), indexSize, isZeroIndexed, indexSize, this.concept.getParentTimeUnit(), offset);
            initialLabel = (String)nextLabel._1;
            cumulativeCarryOverForThisLabel = cumulativeCarryOverForThisLabel.add((TimeDelta)nextLabel._2);
        }
        return Tuple.of((Object)nextLabel._1, (Object)cumulativeCarryOverForThisLabel);
    }

    private Tuple<String, TimeDelta> handleLabelWithFixedLimits(TimeDelta carryOverFromChildConcept, String initialLabel, int offset, TimeUnit parentTimeUnit) {
        int indexSize = this.timeDimension.concept(this.conceptIndex) == TimeConcept.PERIOD ? this.timeDimension.getDataColumn(this.conceptIndex).getCategoryCount() : this.getIndexSize();
        boolean isZeroIndexed = this.timeDimension.isComponentZeroIndexed(this.conceptIndex);
        long totalDistance = carryOverFromChildConcept.getSteps();
        if (this.distance.getUnit() == this.concept.getUnit() && this.concept != TimeConcept.PERIOD || this.concept == TimeConcept.PERIOD && this.matchesNestedIndex(this.distance, this.conceptIndex)) {
            totalDistance += this.distance.getSteps() * (long)offset;
        }
        int carryOverSize = parentTimeUnit == TimeUnit.QUARTER ? 3 : indexSize;
        return this.getNextLabel(initialLabel, totalDistance, indexSize, isZeroIndexed, carryOverSize, parentTimeUnit, offset);
    }

    private boolean matchesNestedIndex(TimeDelta distance, int conceptIndex) {
        return distance.isPeriodic() && conceptIndex == distance.getNestedIndex();
    }

    protected Tuple<String, TimeDelta> getNextLabel(String initialLabel, long distance, int indexSize, boolean isZeroIndexed, int carryOverSize, TimeUnit parentTimeUnit, int offset) {
        List<String> initialLabels = this.getInitialLabels(initialLabel);
        List<String> relevantList = this.getListContainingLabel(initialLabels, isZeroIndexed);
        return this.findNextLabelFromList(relevantList, relevantList.indexOf(initialLabel), distance, indexSize, carryOverSize, parentTimeUnit, offset);
    }

    List<String> getInitialLabels(String initialLabel) {
        return this.categoricalNonNumericalIndexList.isEmpty() ? this.getInitialLabelList(initialLabel) : this.categoricalNonNumericalIndexList;
    }

    List<String> getInitialLabelList(String ... labels) {
        return Arrays.asList(labels);
    }

    public List<String> getLabelsFromIntegerValues(String initialLabel, List<Integer> indexOfNewLabels, boolean isZeroIndexed) {
        if (StringUtils.isEmpty((CharSequence)initialLabel)) {
            throw new IllegalArgumentException("Empty label passed in");
        }
        CyclicalTextLabels.MatchCase matchedCase = this.getCase(initialLabel);
        initialLabel = initialLabel.toLowerCase();
        List<String> initialLabels = this.getInitialLabelList(initialLabel);
        List<String> relevantList = this.getListContainingLabel(initialLabels, isZeroIndexed);
        return indexOfNewLabels.stream().map(value -> isZeroIndexed ? value : value - 1).map(relevantList::get).map(label -> this.getCasedString((String)label, matchedCase)).collect(Collectors.toList());
    }

    String getCasedString(String label, CyclicalTextLabels.MatchCase matchedCase) {
        if (matchedCase == CyclicalTextLabels.MatchCase.UPPER) {
            return label.toUpperCase(this.locale);
        }
        if (matchedCase == CyclicalTextLabels.MatchCase.MIXED) {
            return StringUtils.capitalize((String)label);
        }
        return label;
    }

    public Tuple<String, TimeDelta> findNextLabelFromList(List<String> list, int initialLabelIndex, long distance, int indexSize, int carryOverSize, TimeUnit carryOverUnit, int offset) {
        int indexOfNextLabel = (int)(((long)initialLabelIndex + distance) % (long)indexSize);
        long steps = this.getStep(initialLabelIndex, distance, carryOverSize, offset);
        TimeDelta carryOver = new TimeDelta(steps, carryOverUnit);
        return Tuple.of((Object)list.get(indexOfNextLabel), (Object)carryOver);
    }

    private long getStep(int initialLabelIndex, long distance, int carryOverSize, int offset) {
        long step = ((long)initialLabelIndex + distance) / (long)carryOverSize;
        if (offset == 1) {
            step -= (long)(initialLabelIndex / carryOverSize);
        }
        return step;
    }

    CyclicalTextLabels.MatchCase getCase(String initialLabel) {
        if (StringUtils.isAllUpperCase((CharSequence)initialLabel)) {
            return CyclicalTextLabels.MatchCase.UPPER;
        }
        if (Character.isUpperCase(initialLabel.charAt(0))) {
            return CyclicalTextLabels.MatchCase.MIXED;
        }
        return CyclicalTextLabels.MatchCase.LOWER;
    }

    protected List<String> getListContainingLabel(List<String> initialLabels, boolean isZeroIndexed) {
        if (!this.categoricalNonNumericalIndexList.isEmpty()) {
            return this.categoricalNonNumericalIndexList;
        }
        return this.handleIndexLabel(initialLabels, isZeroIndexed);
    }

    protected List<String> handleIndexLabel(List<String> initialLabels, boolean isZeroIndexed) {
        int startingIndex = isZeroIndexed ? 0 : 1;
        List<String> relevantList = this.getIndexList(startingIndex, this.numberFormat);
        if (this.listContainsAllLabels(initialLabels, relevantList)) {
            return relevantList;
        }
        relevantList = this.getIndexList(startingIndex, this.defaultNumberFormat);
        if (this.listContainsAllLabels(initialLabels, relevantList)) {
            return relevantList;
        }
        throw new IllegalArgumentException("Does not match java date format symbol day");
    }

    protected boolean listContainsAllLabels(List<String> labels, List<String> listToSearch) {
        return labels.stream().allMatch(listToSearch::contains);
    }

    public boolean isTreatAsIndexing() {
        return this.treatAsIndexing;
    }

    public void setTreatAsIndexing(boolean treatAsIndexing) {
        this.treatAsIndexing = treatAsIndexing;
    }

    private String postProcessLabel(Tuple<String, TimeDelta> nextLabel, TimeDelta carryOverForThisConcept, TimeDelta carryOverToNotConsiderForPostProcessing, int loopIndex) {
        String label = (String)nextLabel._1;
        if (!this.treatAsIndexing || carryOverForThisConcept.getSteps() < 1L) {
            return label;
        }
        if (loopIndex == 0) {
            return this.getLabelsAsIndexingLabels(label, 1L);
        }
        return this.getLabelsAsIndexingLabels(label, carryOverForThisConcept.getSteps() - carryOverToNotConsiderForPostProcessing.getSteps());
    }

    private String getLabelsAsIndexingLabels(String label, long numberOfPlusCharacters) {
        StringBuilder bld = new StringBuilder();
        bld.append(label);
        bld.append("+");
        String postFix = this.numberFormat.format(numberOfPlusCharacters);
        bld.append(postFix);
        return bld.toString();
    }

    public TimeConcept getConcept() {
        return this.concept;
    }
}

