/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.labels;

import com.ibm.bi.predict.algorithms.forecasting.labels.CyclicalIndexLabels;
import com.ibm.bi.predict.algorithms.forecasting.labels.LabelUtils;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.util.TextDateNames;
import com.ibm.bi.predict.utils.Tuple;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class CyclicalTextLabels
extends CyclicalIndexLabels {
    public CyclicalTextLabels(Locale locale, TimeDimension timeDimension, int conceptIndex) {
        super(locale, timeDimension, conceptIndex);
    }

    private List<String> getListOfLabels(Locale locale, TextDateNames.TextForm form) {
        return TextDateNames.getConceptLabels(this.concept, locale, form);
    }

    @Override
    protected Tuple<String, TimeDelta> getNextLabel(String initialLabel, long distance, int indexSize, boolean isZeroIndexed, int carryOverSize, TimeUnit parentTimeUnit, int offset) {
        MatchCase matchedCase = this.getCase(initialLabel);
        initialLabel = initialLabel.toLowerCase();
        Tuple<String, TimeDelta> nextLabel = super.getNextLabel(initialLabel, distance, indexSize, isZeroIndexed, carryOverSize, parentTimeUnit, offset);
        String casedString = this.getCasedString((String)nextLabel._1, matchedCase);
        return Tuple.of((Object)casedString, (Object)nextLabel._2);
    }

    @Override
    List<String> getInitialLabels(String initialLabel) {
        return this.categoricalNonNumericalIndexList.isEmpty() ? this.getInitialLabelList(initialLabel) : this.categoricalNonNumericalIndexList.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    protected List<String> getListContainingLabel(List<String> initialLabels, boolean isZeroIndexed) {
        String initialLabel = initialLabels.get(0);
        Optional<Tuple<NumberFormat, Double>> initialValue = LabelUtils.getDoubleValue(initialLabel, this.numberFormat, this.defaultNumberFormat);
        if (initialValue.isPresent()) {
            return this.handleIndexLabel(initialLabels, isZeroIndexed);
        }
        return this.handleStringLabel(initialLabels);
    }

    protected List<String> handleStringLabel(List<String> initialLabels) {
        List<String> relevantList = this.getListOfLabels(this.locale, TextDateNames.TextForm.LONG);
        if (this.listContainsAllLabels(initialLabels, relevantList)) {
            return relevantList;
        }
        relevantList = this.getListOfLabels(this.locale, TextDateNames.TextForm.SHORT);
        if (this.listContainsAllLabels(initialLabels, relevantList)) {
            return relevantList;
        }
        relevantList = this.getListOfLabels(this.defaultLocale, TextDateNames.TextForm.LONG);
        if (this.listContainsAllLabels(initialLabels, relevantList)) {
            return relevantList;
        }
        relevantList = this.getListOfLabels(this.defaultLocale, TextDateNames.TextForm.SHORT);
        if (this.listContainsAllLabels(initialLabels, relevantList)) {
            return relevantList;
        }
        throw new IllegalArgumentException("Does not match java date format symbol day");
    }

    @Override
    protected int getIndexSize() {
        return this.concept.getCycleLength();
    }

    protected static enum MatchCase {
        UPPER,
        LOWER,
        MIXED;

    }
}

