/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResult;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResultData;
import com.ibm.bi.predict.algorithms.forecasting.result.ModelValue;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.result.UpdaterContainers;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class ColumnUpdater {
    private final TimeDimension timeDimension;
    private final ForecastingResult forecastingResult;
    private final UpdaterContainers updateContainers;

    public ColumnUpdater(ForecastingResult forecastingResult) {
        this.timeDimension = ((ForecastingResultData)forecastingResult.getContent()).getTimeDimension();
        this.forecastingResult = forecastingResult;
        this.updateContainers = new UpdaterContainers(this.timeDimension);
    }

    public TimeDimension update() {
        HashSet categorySet = new HashSet(this.updateContainers.getParentColumn().getCategories());
        for (SeriesResult result : ((ForecastingResultData)this.forecastingResult.getContent()).getOrderedSeriesResults()) {
            ModelValue[] forecastedValues = result.getForecastValues();
            Arrays.stream(forecastedValues).forEach(fv -> {
                if (this.updateContainers.getNumComponents() == 1) {
                    this.addNewValuesSingleColumn(this.updateContainers.getNewCategoriesPerColumn().get(0), this.updateContainers.getNewCategoryIndicesPerColumn().get(0), this.updateContainers.getCategoryMapsPerColumn().get(0), (ModelValue)fv);
                } else {
                    this.addNewValuesNestedColumns(categorySet, this.updateContainers.getNewCategoryIndicesPerColumn(), this.updateContainers.getNewCategoriesPerColumn(), this.updateContainers.getCategoryMapsPerColumn(), (ModelValue)fv);
                }
            });
        }
        this.updateTimeDimension();
        return this.timeDimension;
    }

    private String getCategoryStringForIndex(ModelValue fv, int i) {
        return fv.getTime().getValues()[i];
    }

    private void updateTimeDimension() {
        this.setNewColumns(this.updateContainers.getNumComponents(), this.updateContainers.getNewCategoryIndicesPerColumn(), this.updateContainers.getNewCategoriesPerColumn(), this.updateContainers.getOriginalCategoryIndicesPerColumn());
        Set<Integer> newInvalid = this.createNewInvalidIndices(ColumnUpdater.mapColumnCategories(this.updateContainers.getParentColumn()));
        this.timeDimension.setInvalidRowIndices(newInvalid);
    }

    private void addNewValuesSingleColumn(Set<Category> newCategories, List<Integer> newCategoryIndices, Map<String, Integer> categoryMap, ModelValue fv) {
        String newLabel = this.getCategoryStringForIndex(fv, 0);
        if (!categoryMap.keySet().contains(newLabel)) {
            this.handleNewLabel(newCategoryIndices, newCategories, categoryMap, newLabel);
        }
    }

    private void handleNewLabel(List<Integer> newCategoryIndices, Set<Category> newCategories, Map<String, Integer> categoryMap, String categoryLabel) {
        int newIndex = categoryMap.size();
        categoryMap.put(categoryLabel, newIndex);
        newCategoryIndices.add(newIndex);
        newCategories.add(Category.forString((String)categoryLabel));
    }

    private void setNewColumns(int numComponents, List<List<Integer>> newCategoryIndicesPerColumn, List<Set<Category>> newCategoriesPerColumn, List<List<Integer>> originalDataPerColumn) {
        IntStream.range(0, numComponents).forEach(i -> {
            DataColumn newColumn = this.createNewDataColumn(this.timeDimension.getDataColumn(i), (List)originalDataPerColumn.get(i), (List)newCategoryIndicesPerColumn.get(i), new ArrayList<Category>((Collection)newCategoriesPerColumn.get(i)));
            this.timeDimension.setDataColumn(i, newColumn);
        });
    }

    private DataColumn createNewDataColumn(DataColumn column, List<Integer> originalData, List<Integer> newData, List<Category> newCategories) {
        double[] newDataArray = this.createNewDataArray(originalData, newData);
        List<Category> newCategoryList = this.createNewCategoryList(column.getCategories(), newCategories);
        return column.copyWithNewDataAndCategories(newDataArray, newCategoryList);
    }

    private double[] createNewDataArray(List<Integer> originalData, List<Integer> newData) {
        double[] newDataArray = new double[originalData.size() + newData.size()];
        IntStream.range(0, originalData.size()).forEach(i -> {
            newDataArray[i] = ((Integer)originalData.get(i)).intValue();
        });
        IntStream.range(0, newData.size()).forEach(i -> {
            newDataArray[i + originalData.size()] = ((Integer)newData.get(i)).intValue();
        });
        return newDataArray;
    }

    private Set<Integer> createNewInvalidIndices(Map<String, Integer> categoryToIndex) {
        HashSet<Integer> newInvalid = new HashSet<Integer>();
        Set<Category> invalidCategories = this.timeDimension.getInvalidCategories();
        for (Category cat : invalidCategories) {
            newInvalid.add(categoryToIndex.get(cat.toString()));
        }
        return newInvalid;
    }

    private List<Category> createNewCategoryList(List<Category> originalCategories, List<Category> newCategories) {
        ArrayList<Category> newCategoryList = new ArrayList<Category>();
        newCategoryList.addAll(originalCategories);
        newCategoryList.addAll(newCategories);
        return newCategoryList;
    }

    private void addNewValuesNestedColumns(Set<Category> categorySet, List<List<Integer>> newCategoryIndicesPerColumn, List<Set<Category>> newCategoriesPerColumn, List<Map<String, Integer>> categoryMapsPerColumn, ModelValue fv) {
        CharSequence[] timeValues = fv.getTime().getValues();
        String combinedLabel = String.join((CharSequence)"|", timeValues);
        Category combinedCategory = Category.forString((String)combinedLabel);
        if (!categorySet.contains(combinedCategory)) {
            for (int i = 0; i < timeValues.length; ++i) {
                CharSequence categoryLabel = timeValues[i];
                Map<String, Integer> categoryMap = categoryMapsPerColumn.get(i);
                if (!categoryMap.containsKey(categoryLabel)) {
                    this.handleNewLabel(newCategoryIndicesPerColumn.get(i), newCategoriesPerColumn.get(i), categoryMapsPerColumn.get(i), (String)categoryLabel);
                    continue;
                }
                newCategoryIndicesPerColumn.get(i).add(categoryMap.get(categoryLabel));
            }
            categorySet.add(combinedCategory);
        }
    }

    public static void addDataForValidCategory(List<Map<String, Integer>> categoryMapsPerColumn, List<List<Integer>> originalCategoryIndicesPerColumn, Category category) {
        String[] labelComponents = category.toString().split("\\|");
        for (int i = 0; i < labelComponents.length; ++i) {
            if (!categoryMapsPerColumn.get(i).containsKey(labelComponents[i])) {
                throw new ForecastingParametersException("Unexpected values in parent column", ForecastingParametersExceptionKey.DATA_VALUE);
            }
            originalCategoryIndicesPerColumn.get(i).add(categoryMapsPerColumn.get(i).get(labelComponents[i]));
        }
    }

    public static Map<String, Integer> mapColumnCategories(DataColumn column) {
        HashMap<String, Integer> categoryToIndex = new HashMap<String, Integer>();
        for (int i = 0; i < column.getCategoryCount(); ++i) {
            categoryToIndex.put(column.getCategory(i).toString(), i);
        }
        return categoryToIndex;
    }
}

