/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.forecasting.result.TimeValue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ModelValue {
    private TimeValue time;
    private double value;
    private double lowerBound;
    private double upperBound;

    public ModelValue(TimeValue time, double value, double lowerBound, double upperBound) {
        this.time = time;
        this.value = value;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public ModelValue(ModelValue modelValue) {
        this.time = new TimeValue(modelValue.time);
        this.value = modelValue.value;
        this.lowerBound = modelValue.lowerBound;
        this.upperBound = modelValue.upperBound;
    }

    public TimeValue getTime() {
        return this.time;
    }

    public double getValue() {
        return this.value;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public ModelValue add(ModelValue modelValue) {
        if (!this.time.equals(modelValue.getTime())) {
            throw new IllegalArgumentException("Model values with different times cannot be added");
        }
        this.value += modelValue.getValue();
        this.lowerBound += modelValue.getLowerBound();
        this.upperBound += modelValue.getUpperBound();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelValue)) {
            return false;
        }
        ModelValue other = (ModelValue)o;
        return new EqualsBuilder().append((Object)this.time, (Object)other.time).append(this.value, other.value).append(this.lowerBound, other.lowerBound).append(this.upperBound, other.upperBound).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.time).append(this.value).append(this.lowerBound).append(this.upperBound).toHashCode();
    }
}

