/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResultSorter {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ResultSorter.class);

    private ResultSorter() {
    }

    public static <T> List<T> getOrderedResults(Collection<T> results, Function<T, String> idFunc) {
        return results.stream().map(r -> Tuple.of((Object)ResultSorter.safeParse((String)idFunc.apply(r)), (Object)r)).sorted((t1, t2) -> Integer.compare((Integer)t1._1, (Integer)t2._1)).map(t -> t._2).collect(Collectors.toList());
    }

    private static int safeParse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            LOG.debug(() -> String.format("Series result sorting found unexpected key %s", s));
            return 0;
        }
    }
}

