/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.time;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.exception.IrregularDataException;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDifference;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.utils.Tuple;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TimeDelta {
    private static final ZoneId ZONE_ID = TimeZone.getTimeZone("UTC").toZoneId();
    private static final int minimumDeltaForIrregularity = 2;
    private final long steps;
    private final TimeUnit unit;
    private final int nestedIndex;

    private TimeDelta(long steps, TimeUnit unit, int nestedIndex) {
        this.steps = steps;
        this.unit = unit;
        this.nestedIndex = nestedIndex;
    }

    public TimeDelta(long steps, TimeUnit unit) {
        this(steps, unit, -1);
    }

    public TimeDelta(long steps, TimeConcept concept) {
        this(steps, concept.getUnit());
    }

    public TimeDelta(long steps, int nestedIndex) {
        this(steps, TimeUnit.PERIOD, nestedIndex);
    }

    public long getSteps() {
        return this.steps;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int getNestedIndex() {
        return this.nestedIndex;
    }

    public boolean isPeriodic() {
        return this.unit == TimeUnit.PERIOD;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeDelta)) {
            return false;
        }
        TimeDelta timeDelta = (TimeDelta)o;
        return this.steps == timeDelta.steps && this.unit.equals((Object)timeDelta.unit) && this.nestedIndex == timeDelta.nestedIndex;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.steps).append((Object)this.unit).append(this.nestedIndex).toHashCode();
    }

    public TimeDelta add(TimeDelta that) {
        if (this.getUnit() == that.getUnit()) {
            return new TimeDelta(this.steps + that.steps, this.getUnit(), this.nestedIndex);
        }
        return this;
    }

    private static Date[] getDatesFromColumn(TimeDimension dimension) {
        Date[] dates = new Date[dimension.rowCount()];
        int[] rowOrder = dimension.getRowOrder();
        for (int i = 0; i < dimension.rowCount(); ++i) {
            dates[i] = dimension.getDate(rowOrder[i]);
        }
        return dates;
    }

    public static TimeDelta getDateDistance(Date[] sortedDates) {
        if (sortedDates.length < 2) {
            throw new ForecastingParametersException("Cannot compute Time Delta for less than 2 dates", ForecastingParametersExceptionKey.INSUFFICIENT_DATA);
        }
        TimeDifference[] differencesArray = new TimeDifference[sortedDates.length - 1];
        for (int i = 0; i < sortedDates.length - 1; ++i) {
            ZonedDateTime prev = ZonedDateTime.ofInstant(sortedDates[i].toInstant(), ZONE_ID);
            ZonedDateTime now = ZonedDateTime.ofInstant(sortedDates[i + 1].toInstant(), ZONE_ID);
            differencesArray[i] = new TimeDifference(prev, now);
        }
        return TimeDelta.buildTimeDelta(differencesArray);
    }

    public static TimeDelta getNonDateDistance(double[][] sortedLabels, TimeDimension time) {
        if (sortedLabels.length < 2) {
            throw new ForecastingParametersException("Cannot compute Time Delta for less than 2 dates", ForecastingParametersExceptionKey.INSUFFICIENT_DATA);
        }
        TimeDifference[] differencesArray = new TimeDifference[sortedLabels.length - 1];
        for (int i = 0; i < sortedLabels.length - 1; ++i) {
            double[] prev = sortedLabels[i];
            double[] now = sortedLabels[i + 1];
            differencesArray[i] = new TimeDifference(i, prev, now, time);
        }
        if (time.concept(0) == TimeConcept.PERIOD) {
            return TimeDelta.buildPeriodTimeDelta(differencesArray, time);
        }
        return TimeDelta.buildTimeDelta(differencesArray);
    }

    private static TimeDelta buildTimeDelta(TimeDifference[] differencesArray) {
        TimeUnit unit = TimeDelta.findUnitForAll(differencesArray);
        long steps = TimeDelta.findSmallestDelta(differencesArray, unit);
        return new TimeDelta(steps, unit);
    }

    public static long findSmallestDelta(TimeDifference[] differencesArray, TimeUnit unit) {
        Tuple<Set<Long>, Long> minimumDelta = TimeDelta.findMinimumDelta(differencesArray, unit);
        Set differencesByValue = (Set)minimumDelta._1;
        if (differencesByValue.isEmpty()) {
            return 0L;
        }
        long minValue = (Long)minimumDelta._2;
        TimeDelta.checkForIrregularity(differencesByValue, minValue);
        return minValue;
    }

    private static Tuple<Set<Long>, Long> findMinimumDelta(TimeDifference[] differencesArray, TimeUnit unit) {
        HashSet<Long> differencesByValue = new HashSet<Long>();
        long minValue = Long.MAX_VALUE;
        for (int i = 0; i < differencesArray.length; ++i) {
            long value = differencesArray[i].getValueOfUnit(unit);
            if (value == 0L) continue;
            differencesByValue.add(value);
            if (value >= minValue) continue;
            minValue = value;
        }
        return Tuple.of(differencesByValue, (Object)minValue);
    }

    private static void checkForIrregularity(Set<Long> differencesByValue, long minValue) {
        List irregularList;
        if (minValue >= 2L && !(irregularList = differencesByValue.stream().filter(delta -> delta % minValue != 0L).collect(Collectors.toList())).isEmpty()) {
            throw new IrregularDataException("Irregular data");
        }
    }

    private static TimeUnit findUnitForAll(TimeDifference[] allDifferences) {
        TimeUnit minimumUnit = TimeUnit.YEAR;
        for (TimeDifference diffs : allDifferences) {
            Optional<TimeUnit> currUnit = diffs.getLargestNonZeroUnit();
            if (!currUnit.isPresent() || currUnit.get().compareTo(minimumUnit) >= 0) continue;
            minimumUnit = currUnit.get();
        }
        return minimumUnit;
    }

    private static TimeDelta getTimeDeltaForDate(TimeDimension dimension) {
        Date[] orderedDates = TimeDelta.getDatesFromColumn(dimension);
        return TimeDelta.getDateDistance(orderedDates);
    }

    private static TimeDelta getTimeDeltaForNonDate(TimeDimension time) {
        double[][] sortedLabelValues = new double[time.rowCount()][];
        int[] rowOrder = time.getRowOrder();
        for (int i = 0; i < rowOrder.length; ++i) {
            sortedLabelValues[i] = time.getLabelValues(rowOrder[i]);
        }
        return TimeDelta.getNonDateDistance(sortedLabelValues, time);
    }

    public static TimeDelta getTimeDelta(TimeDimension dimension) {
        TimeDelta timeDelta = dimension.isFullDate() ? TimeDelta.getTimeDeltaForDate(dimension) : TimeDelta.getTimeDeltaForNonDate(dimension);
        if (timeDelta.steps == 0L) {
            throw new ForecastingParametersException("All given times are equal, cannot compute time delta", ForecastingParametersExceptionKey.INSUFFICIENT_DATA);
        }
        return timeDelta;
    }

    public Tuple<Long, ChronoUnit> getStepsAsChronoUnits() {
        long distance = this.steps;
        if (this.unit == TimeUnit.QUARTER) {
            distance = 3L * distance;
        }
        return Tuple.of((Object)distance, (Object)this.unit.getChronoUnit());
    }

    public static TimeDelta buildPeriodTimeDelta(TimeDifference[] differencesArray, TimeDimension timeDimension) {
        int nestedIndex = TimeDelta.findLargestNestedIndex(differencesArray);
        TimeDelta.shiftPeriodDifferences(differencesArray, timeDimension, nestedIndex);
        long steps = TimeDelta.findSmallestDelta(differencesArray, TimeUnit.PERIOD);
        return new TimeDelta(steps, nestedIndex);
    }

    private static void shiftPeriodDifferences(TimeDifference[] differencesArray, TimeDimension timeDimension, int nestedIndex) {
        for (int i = 0; i < differencesArray.length; ++i) {
            TimeDifference difference = differencesArray[i];
            int differenceIndex = difference.getNestedIndex();
            if (differenceIndex == nestedIndex) continue;
            long accumulator = difference.getValueOfUnit(TimeUnit.PERIOD);
            for (int j = differenceIndex + 1; j <= nestedIndex; ++j) {
                accumulator *= (long)timeDimension.getDataColumn(j).getCategoryCount();
            }
            differencesArray[i].setValueOfUnit(TimeUnit.PERIOD, accumulator);
            differencesArray[i].setNestedIndex(nestedIndex);
        }
    }

    private static int findLargestNestedIndex(TimeDifference[] differencesArray) {
        int largestIndex = differencesArray[0].getNestedIndex();
        for (TimeDifference diff : differencesArray) {
            largestIndex = diff.getNestedIndex() > largestIndex ? diff.getNestedIndex() : largestIndex;
        }
        return largestIndex;
    }
}

