/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.time;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.exception.UnsortedDataException;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeLimits;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.util.EndOfMonthUtils;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class TimeDifference {
    private final Map<TimeUnit, Long> unitDifferences;
    private final Optional<TimeUnit> largestNonZeroUnit;
    private int nestedIndex = -1;

    public TimeDifference(ZonedDateTime prev, ZonedDateTime now) {
        if (now.isBefore(prev)) {
            throw new UnsortedDataException("Data has to be sorted to compute time delta");
        }
        this.unitDifferences = this.initMap();
        for (TimeUnit unit : this.unitDifferences.keySet()) {
            Long until = prev.until(now, unit.getChronoUnit());
            ZonedDateTime next = prev.plus(until, unit.getChronoUnit());
            if (!next.equals(now)) continue;
            this.unitDifferences.put(unit, until);
        }
        if (EndOfMonthUtils.isLastDayOfMonth(prev) && EndOfMonthUtils.isLastDayOfMonth(now)) {
            this.setDateMonthDifference(prev, now);
        }
        this.largestNonZeroUnit = this.findLargestNonZeroUnit();
    }

    private void setDateMonthDifference(ZonedDateTime prev, ZonedDateTime now) {
        int yearDiff = now.getYear() - prev.getYear();
        long monthDiff = now.getMonthValue() - prev.getMonthValue() + yearDiff * 12;
        this.unitDifferences.put(TimeUnit.MONTH, monthDiff);
    }

    private void setNonDateMonthDifference(double[] prev, double[] now) {
        long monthDiff = (long)((double)((int)now[0]) - prev[0]);
        this.unitDifferences.put(TimeUnit.MONTH, monthDiff);
    }

    private Map<TimeUnit, Long> initMap() {
        LinkedHashMap<TimeUnit, Long> unitMap = new LinkedHashMap<TimeUnit, Long>();
        unitMap.put(TimeUnit.MILLISECOND, 0L);
        unitMap.put(TimeUnit.SECOND, 0L);
        unitMap.put(TimeUnit.MINUTE, 0L);
        unitMap.put(TimeUnit.HOUR, 0L);
        unitMap.put(TimeUnit.DAY, 0L);
        unitMap.put(TimeUnit.MONTH, 0L);
        unitMap.put(TimeUnit.YEAR, 0L);
        return unitMap;
    }

    public TimeDifference(int prevLabelIndex, double[] prev, double[] now, TimeDimension time) {
        int i;
        TimeConcept[] concepts = time.allConcepts();
        this.unitDifferences = this.initMap();
        if (!this.prevIsSmallerOrEqual(prev, now)) {
            throw new UnsortedDataException("Data has to be sorted to compute time delta");
        }
        double[] result = new double[prev.length];
        boolean carry = false;
        for (i = prev.length - 1; i >= 0; --i) {
            int diff = (int)(now[i] - prev[i] - (double)carry);
            if (diff < 0) {
                diff += this.getCycleLength(prevLabelIndex, i, time);
                carry = true;
            } else {
                carry = false;
            }
            result[i] = diff;
        }
        result = this.shiftDifferences(result, prevLabelIndex, time);
        for (i = 0; i < concepts.length; ++i) {
            if (concepts[i] != TimeConcept.PERIOD) {
                this.unitDifferences.put(concepts[i].getUnit(), (long)result[i]);
                continue;
            }
            if (result[i] == 0.0 || this.nestedIndex != -1) continue;
            this.unitDifferences.put(concepts[i].getUnit(), (long)result[i]);
            this.nestedIndex = i;
        }
        if (ConceptUtils.isTime(concepts[concepts.length - 1])) {
            this.adjustHoursAndMinutesFromSeconds();
        }
        if (EndOfMonthUtils.isLastDayOfMonth(prevLabelIndex, prev, time) && EndOfMonthUtils.isLastDayOfMonth(prevLabelIndex + 1, now, time)) {
            this.setNonDateMonthDifference(prev, now);
        }
        this.largestNonZeroUnit = this.findLargestNonZeroUnit();
    }

    private double[] shiftDifferences(double[] diffs, int prevLabelIndex, TimeDimension time) {
        int highestNonZero = 0;
        for (int i = 1; i < diffs.length; ++i) {
            if (diffs[i - 1] <= 0.0) continue;
            if (diffs[i] != 0.0) {
                highestNonZero = i;
            }
            this.shiftDifference(diffs, i, prevLabelIndex, time);
        }
        for (int j = 0; j < highestNonZero; ++j) {
            diffs[j] = 0.0;
        }
        return diffs;
    }

    private void shiftDifference(double[] diffs, int diffIdx, int prevLabelIndex, TimeDimension time) {
        if (diffIdx == 1 && ConceptUtils.isQuarter(time.concept(0))) {
            return;
        }
        int n = diffIdx;
        diffs[n] = diffs[n] + (double)this.getCycleLength(prevLabelIndex, diffIdx, time) * diffs[diffIdx - 1];
    }

    private void adjustHoursAndMinutesFromSeconds() {
        if (!this.unitDifferences.containsKey((Object)TimeUnit.SECOND)) {
            return;
        }
        long seconds = this.unitDifferences.get((Object)TimeUnit.SECOND);
        this.extractTimeUnit(TimeUnit.HOUR, seconds, 3600);
        this.extractTimeUnit(TimeUnit.MINUTE, seconds, 60);
    }

    private void extractTimeUnit(TimeUnit timeUnit, long seconds, int secondsInTimeUnit) {
        if (seconds % (long)secondsInTimeUnit == 0L) {
            long units = seconds / (long)secondsInTimeUnit + this.unitDifferences.getOrDefault((Object)timeUnit, 0L);
            this.unitDifferences.put(timeUnit, units);
        }
    }

    private int getCycleLength(int prevLabelIndex, int conceptIndex, TimeDimension time) {
        TimeConcept concept = time.concept(conceptIndex);
        if (concept == TimeConcept.PERIOD) {
            return time.getDataColumn(conceptIndex).getCategoryCount();
        }
        TimeDelta carryOver = new TimeDelta(0L, TimeUnit.UNKNOWN);
        int limit = TimeLimits.getLimit(conceptIndex, carryOver, time, prevLabelIndex);
        if (limit == -1 && ConceptUtils.isCyclical(conceptIndex)) {
            return concept.getCycleLength();
        }
        return limit;
    }

    private boolean prevIsSmallerOrEqual(double[] prev, double[] now) {
        if (prev.length != now.length) {
            throw new IllegalArgumentException("Time should have the same number of units");
        }
        for (int i = 0; i < prev.length; ++i) {
            if (now[i] > prev[i]) {
                return true;
            }
            if (!(prev[i] > now[i])) continue;
            return false;
        }
        return true;
    }

    public long getValueOfUnit(TimeUnit unit) {
        return this.unitDifferences.getOrDefault((Object)unit, 0L);
    }

    public void setValueOfUnit(TimeUnit unit, long value) {
        this.unitDifferences.put(unit, value);
    }

    public Optional<TimeUnit> getLargestNonZeroUnit() {
        return this.largestNonZeroUnit;
    }

    public int getNestedIndex() {
        return this.nestedIndex;
    }

    public void setNestedIndex(Integer nestedIndex) {
        this.nestedIndex = nestedIndex;
    }

    private Optional<TimeUnit> findLargestNonZeroUnit() {
        return this.unitDifferences.keySet().stream().sorted(Collections.reverseOrder()).filter(u -> this.unitDifferences.containsKey(u)).filter(u -> this.unitDifferences.get(u) != 0L).findFirst();
    }
}

